/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.RemoteIssueType;
import com.atlassian.jira.rpc.soap.client.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.client.RemoteProject;
import com.atlassian.jira.rpc.soap.client.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.client.RemoteScheme;
import com.atlassian.jira.rpc.soap.client.RemoteVersion;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.AbstractSoapExerciser;
import com.atlassian.jira_soapclient.exercise.ExerciserClientConstants;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ProjectAdminSoapExerciser
extends AbstractSoapExerciser {
    public ProjectAdminSoapExerciser(SOAPSession soapSession) {
        super(soapSession);
    }

    public RemoteVersion testCreateVersion() throws RemoteException {
        RemoteVersion version = new RemoteVersion();
        version.setName("3 SOAP created version " + new Date());
        version.setSequence(new Long(6L));
        version.setReleaseDate(this.getDateForServer(2008, 11, 4));
        RemoteVersion createdVersion = this.getJiraSoapService().addVersion(this.getToken(), ExerciserClientConstants.PROJECT_KEY, version);
        System.out.println("createdVersion.getId(): " + createdVersion.getId());
        return createdVersion;
    }

    public RemoteVersion[] testGetVersions(String projectKey) throws RemoteException {
        return this.getJiraSoapService().getVersions(this.getToken(), projectKey);
    }

    private Calendar getDateForServer(int year, int month, int day) throws RemoteException {
        Calendar calServer = Calendar.getInstance();
        calServer.setTimeZone(this.getServerTimeZone());
        calServer.set(year, month, day, 0, 0, 0);
        return calServer;
    }

    private TimeZone getServerTimeZone() throws RemoteException {
        return TimeZone.getTimeZone(this.getJiraSoapService().getServerInfo(this.getToken()).getServerTime().getTimeZoneId());
    }

    public void testReleaseVersion(RemoteVersion remoteVersion, String projectKey) throws RemoteException {
        this.getJiraSoapService().releaseVersion(this.getToken(), projectKey, remoteVersion);
    }

    public void testArchiveVersion(String projectKey, String versionName) throws RemoteException {
        this.getJiraSoapService().archiveVersion(this.getToken(), projectKey, versionName, true);
    }

    public String testCreateProject() throws RemoteException {
        RemoteProject project = new RemoteProject();
        project.setKey(ExerciserClientConstants.CREATE_PROJECT_KEY);
        project.setLead(ExerciserClientConstants.LOGIN_NAME);
        project.setName(ExerciserClientConstants.PROJECT_NAME);
        project.setDescription(ExerciserClientConstants.PROJECT_DESCRIPTION);
        RemotePermissionScheme defaultPermScheme = new RemotePermissionScheme();
        defaultPermScheme.setId(new Long(0L));
        project.setPermissionScheme(defaultPermScheme);
        RemoteProject returnedProject = this.testCreateProjectFromObject(project);
        String projectKey = returnedProject.getKey();
        System.out.println("Created project " + projectKey);
        return projectKey;
    }

    public RemoteProject testCreateProjectFromObject(RemoteProject project) throws RemoteException {
        return this.getJiraSoapService().createProjectFromObject(this.getToken(), project);
    }

    public void testDeleteProject(String projectKey) throws RemoteException {
        this.getJiraSoapService().deleteProject(this.getToken(), projectKey);
        System.out.println("Deleted project " + projectKey);
    }

    public RemoteIssueType[] getIssueTypesForProject(String userName, String password, String projectId) throws RemoteException {
        String currentToken = this.getTokenForUser(userName, password);
        return this.getJiraSoapService().getIssueTypesForProject(currentToken, projectId);
    }

    public RemoteIssueType[] getSubTaskIssueTypesForProject(String userName, String password, String projectId) throws RemoteException {
        String currentToken = this.getTokenForUser(userName, password);
        return this.getJiraSoapService().getSubTaskIssueTypesForProject(currentToken, projectId);
    }

    public RemoteScheme[] testGetAssociatedNotificationSchemes(RemoteProjectRole remoteprojectRole) throws RemoteException {
        return this.getJiraSoapService().getAssociatedNotificationSchemes(this.getToken(), remoteprojectRole);
    }

    public RemoteScheme[] testGetAssociatedPermissionSchemes(RemoteProjectRole remoteprojectRole) throws RemoteException {
        return this.getJiraSoapService().getAssociatedPermissionSchemes(this.getToken(), remoteprojectRole);
    }

    public RemoteProject testGetProjectById(Long id) throws RemoteException {
        return this.getJiraSoapService().getProjectById(this.getToken(), id);
    }

    public RemoteProject testGetProjectByKey(String key) throws RemoteException {
        return this.getJiraSoapService().getProjectByKey(this.getToken(), key);
    }
}

