/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.RemoteConfiguration;
import com.atlassian.jira.rpc.soap.client.RemoteIssueType;
import com.atlassian.jira.rpc.soap.client.RemotePermission;
import com.atlassian.jira.rpc.soap.client.RemotePriority;
import com.atlassian.jira.rpc.soap.client.RemoteResolution;
import com.atlassian.jira.rpc.soap.client.RemoteServerInfo;
import com.atlassian.jira.rpc.soap.client.RemoteStatus;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.AbstractSoapExerciser;
import java.rmi.RemoteException;

public class JiraAdminSoapExerciser
extends AbstractSoapExerciser {
    public JiraAdminSoapExerciser(SOAPSession soapSession) {
        super(soapSession);
    }

    public RemoteServerInfo testGetRemoteServerInfo() throws RemoteException {
        System.out.println("Testing getRemoteServerInfo ...");
        RemoteServerInfo serverInfo = this.getJiraSoapService().getServerInfo(this.getToken());
        System.out.println("Returned Server Info:");
        System.out.println("Current server timezone: " + serverInfo.getServerTime().getTimeZoneId());
        System.out.println("Current server time: " + serverInfo.getServerTime().getServerTime());
        return serverInfo;
    }

    public RemoteConfiguration testGetRemoteConfiguration() throws RemoteException {
        System.out.println("Testing getRemoteConfiguration ...");
        RemoteConfiguration config = this.getJiraSoapService().getConfiguration(this.getToken());
        System.out.println("Returned Configuration: \nAllow Attachments: " + config.isAllowAttachments() + "\nAllow Issue Linking: " + config.isAllowIssueLinking());
        return config;
    }

    public RemotePermission[] testGetAllPermissions() throws RemoteException {
        RemotePermission[] allPermissions = this.getJiraSoapService().getAllPermissions(this.getToken());
        for (int i = 0; i < allPermissions.length; ++i) {
            RemotePermission allPermission = allPermissions[i];
            System.out.println("allPermission.getName(): " + allPermission.getName());
        }
        return allPermissions;
    }

    public RemoteIssueType[] getIssueTypes(String userName, String password) throws RemoteException {
        String currentToken = this.getTokenForUser(userName, password);
        return this.getJiraSoapService().getIssueTypes(currentToken);
    }

    public RemoteIssueType[] getSubTaskIssueTypes(String userName, String password) throws RemoteException {
        String currentToken = this.getTokenForUser(userName, password);
        return this.getJiraSoapService().getSubTaskIssueTypes(currentToken);
    }

    public RemotePriority[] getPriorities(String userName, String password) throws RemoteException {
        String currentToken = this.getTokenForUser(userName, password);
        return this.getJiraSoapService().getPriorities(currentToken);
    }

    public RemoteStatus[] getStatuses(String userName, String password) throws RemoteException {
        String currentToken = this.getTokenForUser(userName, password);
        return this.getJiraSoapService().getStatuses(currentToken);
    }

    public RemoteResolution[] getResolutions(String userName, String password) throws RemoteException {
        String currentToken = this.getTokenForUser(userName, password);
        return this.getJiraSoapService().getResolutions(currentToken);
    }
}

