/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.client.RemoteField;
import com.atlassian.jira.rpc.soap.client.RemoteFieldValue;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.AbstractSoapExerciser;
import com.atlassian.jira_soapclient.exercise.ExerciserClientConstants;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Calendar;

public class IssueSoapExerciser
extends AbstractSoapExerciser {
    public IssueSoapExerciser(SOAPSession soapSession) {
        super(soapSession);
    }

    public RemoteCustomFieldValue[] testGetCustomFieldValues(String issueKey) throws RemoteException {
        System.out.println("Testing getting Custom Field values for Issue " + issueKey);
        RemoteField[] remoteFields = this.getJiraSoapService().getCustomFields(this.getToken());
        RemoteIssue issue = this.getJiraSoapService().getIssue(this.getToken(), issueKey);
        RemoteCustomFieldValue[] customFieldValues = issue.getCustomFieldValues();
        for (int i = 0; i < customFieldValues.length; ++i) {
            System.out.println("Custom Field Id: " + customFieldValues[i].getCustomfieldId());
            String[] values = customFieldValues[i].getValues();
            for (int j = 0; j < values.length; ++j) {
                System.out.println("Custom Field Value: " + values[j]);
            }
        }
        System.out.println("Ending getting Custom Field values for Issue " + issueKey);
        return customFieldValues;
    }

    public RemoteIssue testGetIssueById(String issueId) throws RemoteException {
        System.out.println("Testing getIssueById ...");
        RemoteIssue issue = this.getJiraSoapService().getIssueById(this.getToken(), issueId);
        System.out.println("Returned an issue id: " + issue.getId() + " key: " + issue.getKey());
        return issue;
    }

    public RemoteIssue[] testFindIssuesWithTerm(String term) throws RemoteException {
        long startTime = System.currentTimeMillis();
        RemoteIssue[] issuesFromTextSearch = this.getJiraSoapService().getIssuesFromTextSearch(this.getToken(), term);
        System.out.println(issuesFromTextSearch.length + " issues with term \"" + term + "\"");
        for (int i = 0; i < issuesFromTextSearch.length; ++i) {
            RemoteIssue remoteIssue = issuesFromTextSearch[i];
            System.out.println("\t" + remoteIssue.getKey() + " " + remoteIssue.getSummary());
        }
        System.out.println("Time taken for search: " + (System.currentTimeMillis() - startTime) + "ms");
        return issuesFromTextSearch;
    }

    public void testUpdateIssue(String issueKey, String custom_field_key_1, String custom_field_value_1, String custom_field_key_2, String custom_field_value_2) throws RemoteException {
        this.testGetFieldsForEdit(issueKey);
        RemoteFieldValue[] actionParams = new RemoteFieldValue[]{new RemoteFieldValue("summary", new String[]{ExerciserClientConstants.NEW_SUMMARY}), new RemoteFieldValue(custom_field_key_1, new String[]{custom_field_value_1}), new RemoteFieldValue(custom_field_key_2, new String[]{custom_field_value_2})};
        this.getJiraSoapService().updateIssue(this.getToken(), issueKey, actionParams);
    }

    public void testGetFieldsForEdit(String issueKey) throws RemoteException {
        System.out.println("The issue " + issueKey + " has the following editable fields:");
        RemoteField[] fieldsForEdit = this.getJiraSoapService().getFieldsForEdit(this.getToken(), issueKey);
        for (int i = 0; i < fieldsForEdit.length; ++i) {
            RemoteField remoteField = fieldsForEdit[i];
            System.out.println("\tremoteField: " + remoteField.getId());
        }
    }

    public RemoteIssue testCreateIssue(RemoteIssue issue) throws RemoteException {
        RemoteIssue returnedIssue = this.getJiraSoapService().createIssue(this.getToken(), issue);
        String issueKey = returnedIssue.getKey();
        System.out.println("Successfully created issue " + issueKey);
        this.printIssueDetails(returnedIssue);
        return returnedIssue;
    }

    public Calendar testGetResolutionDate(String issueKey) throws RemoteException {
        return this.getJiraSoapService().getResolutionDateByKey(this.getToken(), issueKey);
    }

    public Calendar testGetResolutionDate(Long issueId) throws RemoteException {
        return this.getJiraSoapService().getResolutionDateById(this.getToken(), issueId);
    }

    public RemoteIssue testCreateIssueWithSecurity(RemoteIssue issue, long securityLevelId) throws RemoteException {
        RemoteIssue returnedIssue = this.getJiraSoapService().createIssueWithSecurityLevel(this.getToken(), issue, securityLevelId);
        String issueKey = returnedIssue.getKey();
        System.out.println("Successfully created issue " + issueKey);
        this.printIssueDetails(returnedIssue);
        return returnedIssue;
    }

    private void printIssueDetails(RemoteIssue issue) {
        System.out.println("Issue Details");
        Method[] declaredMethods = issue.getClass().getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            if (!declaredMethod.getName().startsWith("get") || declaredMethod.getParameterTypes().length != 0) continue;
            System.out.print("Issue." + declaredMethod.getName() + "() -> ");
            try {
                Object o = declaredMethod.invoke((Object)issue, new Object[0]);
                if (o instanceof Object[]) {
                    System.out.println(this.printArray((Object[])o));
                    continue;
                }
                System.out.println(o);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private String printArray(Object[] o) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < o.length; ++i) {
            sb.append(o[i]).append(" ");
        }
        return sb.toString();
    }
}

