/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.RemoteFilter;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.AbstractSoapExerciser;
import java.rmi.RemoteException;

public class FiltersSoapExerciser
extends AbstractSoapExerciser {
    public FiltersSoapExerciser(SOAPSession soapSession) {
        super(soapSession);
    }

    public long testGetIssueCountForFilter(String filterId) throws RemoteException {
        System.out.println("Testing getIssueCountForFilter ...");
        long issueCount = this.getJiraSoapService().getIssueCountForFilter(this.getToken(), filterId);
        System.out.println("Returned an issue count of " + issueCount + " for filter " + filterId);
        return issueCount;
    }

    public RemoteFilter[] testGetFilters() throws RemoteException {
        System.out.println("Favourite filters:");
        RemoteFilter[] savedFilters = this.getJiraSoapService().getFavouriteFilters(this.getToken());
        for (int i = 0; i < savedFilters.length; ++i) {
            RemoteFilter filter = savedFilters[i];
            String description = filter.getDescription() != null ? ": " + filter.getDescription() : "";
            System.out.println("\t" + filter.getName() + description);
        }
        return savedFilters;
    }

    public RemoteIssue[] testGetIssuesFromTextSearch(String text) throws RemoteException {
        RemoteIssue[] issues = this.getJiraSoapService().getIssuesFromTextSearch(this.getToken(), text);
        for (int i = 0; i < issues.length; ++i) {
            RemoteIssue issue = issues[i];
            System.out.println("issue.getSummary(): " + issue.getSummary());
        }
        return issues;
    }

    public RemoteIssue[] testGetIssuesFromTextSearchWithLimit(String text, int offSet, int maxResults) throws RemoteException {
        RemoteIssue[] issues = this.getJiraSoapService().getIssuesFromTextSearchWithLimit(this.getToken(), text, offSet, maxResults);
        for (int i = 0; i < issues.length; ++i) {
            RemoteIssue issue = issues[i];
            System.out.println("issue.getSummary(): " + issue.getSummary());
        }
        return issues;
    }

    public RemoteIssue[] testGetIssuesFromFilter(String filterId) throws RemoteException {
        RemoteIssue[] issues = this.getJiraSoapService().getIssuesFromFilter(this.getToken(), filterId);
        for (int i = 0; i < issues.length; ++i) {
            RemoteIssue issue = issues[i];
            System.out.println("issue.getSummary(): " + issue.getSummary());
        }
        return issues;
    }

    public RemoteIssue[] testGetIssuesFromFilterWithLimit(String filterId, int offSet, int maxResults) throws RemoteException {
        RemoteIssue[] issues = this.getJiraSoapService().getIssuesFromFilterWithLimit(this.getToken(), filterId, offSet, maxResults);
        for (int i = 0; i < issues.length; ++i) {
            RemoteIssue issue = issues[i];
            System.out.println("issue.getSummary(): " + issue.getSummary());
        }
        return issues;
    }

    public RemoteIssue[] testGetIssuesFromTextSearchWithProjectWithMax(String[] projectKeys, String text, int maxResults) throws RemoteException {
        RemoteIssue[] issues = this.getJiraSoapService().getIssuesFromTextSearchWithProject(this.getToken(), projectKeys, text, maxResults);
        for (int i = 0; i < issues.length; ++i) {
            RemoteIssue issue = issues[i];
            System.out.println("issue.getSummary(): " + issue.getSummary());
        }
        return issues;
    }
}

