/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.RemoteAttachment;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.AbstractSoapExerciser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.encoding.Base64;

public class AttachmentsSoapExerciser
extends AbstractSoapExerciser {
    public AttachmentsSoapExerciser(SOAPSession soapSession) {
        super(soapSession);
    }

    public String testAddAttachment(RemoteIssue issue) throws IOException {
        AttachmentBean ab = this.createAttachment("A sample file attached via SOAP to JIRA issue " + issue.getKey());
        boolean added = this.getJiraSoapService().addAttachmentsToIssue(this.getToken(), issue.getKey(), AttachmentResolver.getFileNames(ab), AttachmentResolver.getByteArrayData(ab));
        System.out.println((added ? "Added" : "Failed to add") + " attachment " + ab.getFileName() + " to issue " + issue.getKey());
        return ab.getFileName();
    }

    public String[] testAddMultipleAttachmentsUsingBase64(RemoteIssue issue) throws IOException {
        List attachments = this.createMultipleAttachments(issue.getKey(), 5);
        String[] fileNames = AttachmentResolver.getFileNames(attachments);
        boolean added = this.getJiraSoapService().addBase64EncodedAttachmentsToIssue(this.getToken(), issue.getKey(), fileNames, AttachmentResolver.getBase64Data(attachments));
        System.out.println((added ? "Added" : "Failed to add") + " attachments " + fileNames.toString() + " to issue " + issue.getKey());
        return fileNames;
    }

    public String testAddLargeAttachmentUsingBase64(RemoteIssue issue, int fileSize) throws IOException {
        AttachmentBean ab = this.createAttachment("A sample file attached via SOAP to JIRA issue " + issue.getKey(), fileSize);
        boolean added = this.getJiraSoapService().addBase64EncodedAttachmentsToIssue(this.getToken(), issue.getKey(), AttachmentResolver.getFileNames(ab), AttachmentResolver.getBase64Data(ab));
        System.out.println((added ? "Added" : "Failed to add") + " attachment " + ab.getFileName() + " to issue " + issue.getKey());
        return ab.getFileName();
    }

    public RemoteAttachment[] testGetAttachments(String issueKey) throws RemoteException {
        return this.getJiraSoapService().getAttachmentsFromIssue(this.getToken(), issueKey);
    }

    private byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length < Integer.MAX_VALUE) {
            int offset;
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            return bytes;
        }
        System.out.println("File is too large");
        return null;
    }

    private List createMultipleAttachments(String issueKey, int size) throws IOException {
        String content = "A sample file attached via SOAP to JIRA issue " + issueKey;
        ArrayList<AttachmentBean> attachments = new ArrayList<AttachmentBean>(size);
        for (int i = 0; i < size; ++i) {
            attachments.add(this.createAttachment(content));
        }
        return attachments;
    }

    private AttachmentBean createAttachment(String content) throws IOException {
        return this.createAttachment(content, content.length());
    }

    private AttachmentBean createAttachment(String content, int fileSize) throws IOException {
        File tmpFile = File.createTempFile("attachment", ".txt");
        FileWriter fw = new FileWriter(tmpFile);
        fw.write(this.getLongString(content, fileSize));
        fw.close();
        AttachmentBean ab = new AttachmentBean();
        ab.setFileName(tmpFile.getName());
        ab.setData(this.getBytesFromFile(tmpFile));
        tmpFile.delete();
        return ab;
    }

    private String getLongString(String pattern, int length) {
        StringBuffer sb = new StringBuffer(length);
        while (sb.length() < length) {
            int remainingLength = length - sb.length();
            sb.append(pattern.substring(0, Math.min(remainingLength, pattern.length())));
        }
        return sb.toString();
    }

    private static class AttachmentBean {
        private String fileName;
        private Object data;

        private AttachmentBean() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }

    private static class AttachmentResolver {
        private AttachmentResolver() {
        }

        private static String[] getFileNames(AttachmentBean attachment) {
            ArrayList<AttachmentBean> attachments = new ArrayList<AttachmentBean>();
            attachments.add(attachment);
            return AttachmentResolver.getFileNames(attachments);
        }

        private static String[] getFileNames(List attachments) {
            String[] fileNames = new String[attachments.size()];
            int i = 0;
            for (AttachmentBean ab : attachments) {
                fileNames[i++] = ab.getFileName();
            }
            return fileNames;
        }

        private static byte[][] getByteArrayData(AttachmentBean attachment) {
            ArrayList<AttachmentBean> attachments = new ArrayList<AttachmentBean>();
            attachments.add(attachment);
            return AttachmentResolver.getByteArrayData(attachments);
        }

        private static byte[][] getByteArrayData(List attachments) {
            byte[][] dataArrays = new byte[attachments.size()][];
            int i = 0;
            for (AttachmentBean ab : attachments) {
                byte[] data = (byte[])ab.getData();
                dataArrays[i++] = data;
            }
            return dataArrays;
        }

        private static String[] getBase64Data(AttachmentBean attachment) {
            ArrayList<AttachmentBean> attachments = new ArrayList<AttachmentBean>();
            attachments.add(attachment);
            return AttachmentResolver.getBase64Data(attachments);
        }

        private static String[] getBase64Data(List attachments) {
            String[] dataStrings = new String[attachments.size()];
            int i = 0;
            for (AttachmentBean ab : attachments) {
                byte[] data = (byte[])ab.getData();
                dataStrings[i++] = Base64.encode((byte[])data);
            }
            return dataStrings;
        }
    }
}

