/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.JiraSoapService;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.ExerciserClientConstants;
import java.rmi.RemoteException;

abstract class AbstractSoapExerciser {
    final SOAPSession soapSession;

    public AbstractSoapExerciser(SOAPSession soapSession) {
        this.soapSession = soapSession;
    }

    public void soapConnect() throws RemoteException {
        this.soapConnect(ExerciserClientConstants.LOGIN_NAME, ExerciserClientConstants.LOGIN_PASSWORD);
    }

    public void soapConnect(String userName, String password) throws RemoteException {
        this.soapSession.connect(userName, password);
    }

    public JiraSoapService getJiraSoapService() {
        return this.soapSession.getJiraSoapService();
    }

    public String getToken() {
        return this.soapSession.getAuthenticationToken();
    }

    public String getTokenForUser(String userName, String password) throws RemoteException {
        String currentToken = userName != null && password != null ? this.getJiraSoapService().login(userName, password) : this.getToken();
        return currentToken;
    }
}

