/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient;

import com.atlassian.jira.rpc.soap.client.JiraSoapService;
import com.atlassian.jira.rpc.soap.client.RemoteComment;
import com.atlassian.jira.rpc.soap.client.RemoteComponent;
import com.atlassian.jira.rpc.soap.client.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.client.RemoteFilter;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.atlassian.jira.rpc.soap.client.RemoteVersion;
import com.atlassian.jira_soapclient.SOAPSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public class SOAPClient {
    static final String LOGIN_NAME = "soaptester";
    static final String LOGIN_PASSWORD = "soaptester";
    static final String PROJECT_KEY = "TST";
    static final String ISSUE_TYPE_ID = "1";
    static final String SUMMARY_NAME = "An issue created via the JIRA SOAPClient sample : " + new Date();
    static final String PRIORITY_ID = "4";
    static final String COMPONENT_ID = "10240";
    static final String VERSION_ID = "10330";
    static final String NEW_SUMMARY = "New summary";
    static final String CUSTOM_FIELD_KEY_1 = "customfield_10061";
    static final String CUSTOM_FIELD_VALUE_1 = "10098";
    static final String CUSTOM_FIELD_KEY_2 = "customfield_10061:1";
    static final String CUSTOM_FIELD_VALUE_2 = "10105";
    static final String NEW_COMMENT_BODY = "This is a new comment";
    static final String FILTER_ID_FIXED_FOR_RELEASED_VERSION = "12355";
    static final String SOAP_AS_A_SEARCH_TERM = "SOAPClient";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String baseUrl = "http://jira.atlassian.com/rpc/soap/jirasoapservice-v2";
        Timing timing = Timing.startTiming("JIRA SOAP client sample");
        try {
            SOAPSession soapSession = new SOAPSession(new URL(baseUrl));
            Timing loginTiming = Timing.startTiming("Login");
            try {
                soapSession.connect("soaptester", "soaptester");
            }
            finally {
                loginTiming.printTiming();
            }
            JiraSoapService jiraSoapService = soapSession.getJiraSoapService();
            String authToken = soapSession.getAuthenticationToken();
            RemoteIssue issue = SOAPClient.testCreateIssue(jiraSoapService, authToken);
            SOAPClient.testAddAttachment(jiraSoapService, authToken, issue);
            String issueKey = issue.getKey();
            SOAPClient.testGetIssueById(jiraSoapService, authToken, issue.getId());
            SOAPClient.testAddComment(jiraSoapService, authToken, issueKey);
            SOAPClient.testGetFavouriteFilters(jiraSoapService, authToken);
            SOAPClient.testGetIssueCountForFilter(jiraSoapService, authToken, FILTER_ID_FIXED_FOR_RELEASED_VERSION);
            SOAPClient.testGetIssuesForFilter(jiraSoapService, authToken, FILTER_ID_FIXED_FOR_RELEASED_VERSION);
            SOAPClient.testFindIssuesWithTerm(jiraSoapService, authToken, SOAP_AS_A_SEARCH_TERM);
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGetIssueById(JiraSoapService jiraSoapService, String token, String issueId) throws RemoteException {
        Timing timing = Timing.startTiming("GetIssueById");
        try {
            System.out.println("Testing getIssueById ...");
            RemoteIssue issue = jiraSoapService.getIssueById(token, issueId);
            System.out.println("\tReturned an issue id: " + issue.getId() + " key: " + issue.getKey());
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGetIssueCountForFilter(JiraSoapService jiraSoapService, String token, String filterId) throws RemoteException {
        Timing timing = Timing.startTiming("GetIssueCountForFilter");
        try {
            System.out.println("Testing getIssueCountForFilter ...");
            long issueCount = jiraSoapService.getIssueCountForFilter(token, filterId);
            System.out.println("\tReturned an issue count of " + issueCount + " for filter " + filterId);
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAddAttachment(JiraSoapService jiraSoapService, String token, RemoteIssue issue) throws IOException {
        Timing timing = Timing.startTiming("AddAttachment");
        try {
            File tmpFile = File.createTempFile("attachment", ".txt");
            FileWriter fw = new FileWriter(tmpFile);
            fw.write("A sample file attached via SOAP to JIRA issue " + issue.getKey());
            fw.close();
            boolean added = jiraSoapService.addAttachmentsToIssue(token, issue.getKey(), new String[]{tmpFile.getName()}, new byte[][]{SOAPClient.getBytesFromFile(tmpFile)});
            System.out.println("\t" + (added ? "Added" : "Failed to add") + " attachment " + tmpFile.getName() + " to issue " + issue.getKey());
            tmpFile.delete();
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGetFavouriteFilters(JiraSoapService jiraSoapService, String token) throws RemoteException {
        Timing timing = Timing.startTiming("GetSavedFilters");
        try {
            RemoteFilter[] savedFilters = jiraSoapService.getFavouriteFilters(token);
            System.out.println("Found " + savedFilters.length + " favourite filters");
            for (int i = 0; i < savedFilters.length; ++i) {
                RemoteFilter filter = savedFilters[i];
                String description = filter.getDescription() != null ? ": " + filter.getDescription() : "";
                System.out.println("\t" + filter.getName() + " (" + filter.getId() + ") - " + description);
            }
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGetIssuesForFilter(JiraSoapService jiraSoapService, String token, String filterId) throws RemoteException {
        Timing timing = Timing.startTiming("GetIssuesForFilter");
        try {
            RemoteIssue[] issues = jiraSoapService.getIssuesFromFilter(token, filterId);
            System.out.println("Found " + issues.length + " issues for filter(" + filterId + ")");
            for (int i = 0; i < issues.length; ++i) {
                RemoteIssue issue = issues[i];
                System.out.println("\t" + issue.getKey() + " -" + issue.getSummary());
            }
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFindIssuesWithTerm(JiraSoapService jiraSoapService, String token, String term) throws RemoteException {
        Timing timing = Timing.startTiming("FindIssuesWithTerm '" + term + "'");
        try {
            RemoteIssue[] issuesFromTextSearch = jiraSoapService.getIssuesFromTextSearch(token, term);
            System.out.println("Found " + issuesFromTextSearch.length + " issues with term \"" + term + "\"");
            for (int i = 0; i < issuesFromTextSearch.length; ++i) {
                RemoteIssue remoteIssue = issuesFromTextSearch[i];
                System.out.println("\t" + remoteIssue.getKey() + "\t" + remoteIssue.getSummary());
            }
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAddComment(JiraSoapService jiraSoapService, String token, String issueKey) throws RemoteException {
        Timing timing = Timing.startTiming("AddComment");
        try {
            RemoteComment comment = new RemoteComment();
            comment.setBody(NEW_COMMENT_BODY);
            jiraSoapService.addComment(token, issueKey, comment);
        }
        finally {
            timing.printTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RemoteIssue testCreateIssue(JiraSoapService jiraSoapService, String token) throws RemoteException {
        Timing timing = Timing.startTiming("CreateIssue");
        try {
            RemoteIssue issue = new RemoteIssue();
            issue.setProject(PROJECT_KEY);
            issue.setType(ISSUE_TYPE_ID);
            issue.setSummary(SUMMARY_NAME);
            issue.setPriority(PRIORITY_ID);
            issue.setDuedate(Calendar.getInstance());
            issue.setAssignee("");
            RemoteComponent component = new RemoteComponent();
            component.setId(COMPONENT_ID);
            issue.setComponents(new RemoteComponent[]{component});
            RemoteVersion version = new RemoteVersion();
            version.setId(VERSION_ID);
            RemoteVersion[] remoteVersions = new RemoteVersion[]{version};
            issue.setFixVersions(remoteVersions);
            RemoteCustomFieldValue customFieldValue = new RemoteCustomFieldValue(CUSTOM_FIELD_KEY_1, "", new String[]{CUSTOM_FIELD_VALUE_1});
            RemoteCustomFieldValue customFieldValue2 = new RemoteCustomFieldValue(CUSTOM_FIELD_KEY_2, "", new String[]{CUSTOM_FIELD_VALUE_2});
            RemoteCustomFieldValue[] customFieldValues = new RemoteCustomFieldValue[]{customFieldValue, customFieldValue2};
            issue.setCustomFieldValues(customFieldValues);
            RemoteIssue returnedIssue = jiraSoapService.createIssue(token, issue);
            String issueKey = returnedIssue.getKey();
            System.out.println("\tSuccessfully created issue " + issueKey);
            SOAPClient.printIssueDetails(returnedIssue);
            RemoteIssue remoteIssue = returnedIssue;
            return remoteIssue;
        }
        finally {
            timing.printTiming();
        }
    }

    private static void printIssueDetails(RemoteIssue issue) {
        System.out.println("Issue Details : ");
        Method[] declaredMethods = issue.getClass().getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            if (!declaredMethod.getName().startsWith("get") || declaredMethod.getParameterTypes().length != 0) continue;
            System.out.print("\t Issue." + declaredMethod.getName() + "() -> ");
            try {
                Object obj = declaredMethod.invoke((Object)issue, new Object[0]);
                if (obj instanceof Object[]) {
                    obj = SOAPClient.arrayToStr((Object[])obj);
                }
                System.out.println(obj);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static String arrayToStr(Object[] o) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < o.length; ++i) {
            sb.append(o[i]).append(" ");
        }
        return sb.toString();
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length < Integer.MAX_VALUE) {
            int offset;
            int numRead;
            byte[] bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            return bytes;
        }
        System.out.println("File is too large");
        return null;
    }

    private static class Timing {
        private String operationDesc;
        private long then;

        private Timing(String operationDesc) {
            this.operationDesc = operationDesc;
            this.then = System.currentTimeMillis();
        }

        private static Timing startTiming(String operationDesc) {
            System.out.println("\nRunning : " + operationDesc);
            return new Timing(operationDesc);
        }

        private void printTiming() {
            long howLong = System.currentTimeMillis() - this.then;
            System.out.println("________________________________________________________________");
            DecimalFormat decFormat = new DecimalFormat("###,##0");
            System.out.println("\t" + this.operationDesc + " took " + decFormat.format(howLong) + " ms to run");
        }
    }
}

