/**
 * Marionete application that control optimizer components
 */
define('jira/optimizer-plugin/application', ['jira-optimizer-plugin/backbone-1.1.2', 'jira-optimizer-plugin/marionette-2.1.0', 'wrm/context-path', 'jira/optimizer-plugin/router', 'jira/optimizer-plugin/optimizerLayoutView'], function (Backbone, Marionette, contextPath, Router, LayoutView) {
    'use strict';

    var FETCH_INFO_URL = '/rest/optimizer/1/recommendations/info';
    return new Marionette.Application({
        onBeforeStart: function onBeforeStart() {

            this.layout = new LayoutView({ el: 'main#main' });

            this.statusModel = new (Backbone.Model.extend({
                url: function url() {
                    return contextPath() + FETCH_INFO_URL;
                }
            }))();
        },

        onStart: function onStart(options) {
            var _this = this;

            this.statusModel.fetch().done(function (response) {
                _this.categoriesCollection = new Backbone.Collection(response.values);

                var router = new Router({
                    statusModel: _this.statusModel,
                    categoriesCollection: _this.categoriesCollection,
                    layout: _this.layout
                });

                if (!_this.statusModel.get('lastScan')) {
                    window.location.hash = 'welcome';
                }

                if (!Backbone.History.started) {
                    Backbone.history.start();
                }
            });
        }
    });
});