/**
 * This view renders confirmation for optimizing a recommendation
 */
define('jira/optimizer-plugin/confirmationView', ['jquery', 'jira-optimizer-plugin/marionette-2.1.0', 'jira/dialog/dialog'], function ($, Marionette, Dialog) {
    'use strict';

    return Marionette.ItemView.extend({
        template: false,
        ui: {
            confirmButton: '#confirm-cf-optimize-button',
            cancelButton: '#cf-context-optimize-cancel-button'
        },
        events: {
            'click @ui.confirmButton': 'onConfirm',
            'click @ui.cancelButton': 'destroy'
        },
        initialize: function initialize() {
            this.dialog = new Dialog({
                id: "jgp-optimize-confirmation-dialog",
                content: $(CustomfieldAnalyzer.Templates.confirmation(this.model.toJSON()))
            });
            this.render();
        },
        onRender: function onRender() {
            this.dialog.show();
            this.setElement(this.dialog.get$popup());
            this.bindUIElements();
        },
        onConfirm: function onConfirm() {
            this.dialog.showFooterLoadingIndicator();
            this.ui.confirmButton.attr("disabled", "disabled");
            this.ui.cancelButton.attr("disabled", "disabled");
            this.trigger('confirm');
        },
        destroy: function destroy() {
            if (this.dialog) {
                this.dialog.hide();
            }
            Marionette.ItemView.prototype.destroy.call(this);
        }
    });
});