/**
 * Renders the summary (Total recommendations count, Severity etc) of a particular type of recommendation
 */
define('jira/optimizer-plugin/categoryView', ['jira-optimizer-plugin/backbone-1.1.2', 'jira-optimizer-plugin/marionette-2.1.0'], function (Backbone, Marionette) {
    'use strict';

    return Marionette.ItemView.extend({
        template: function template(data) {
            return CustomfieldAnalyzer.Templates.Category({ category: data });
        },
        tagName: 'li',
        className: 'category',
        ui: {
            linkButton: '[name="view-custom-fields"]'
        },
        events: {
            'click @ui.linkButton': 'displayRecommendations'
        },
        displayRecommendations: function displayRecommendations() {
            Backbone.history.navigate('recommendations/' + this.model.get('category'), {
                trigger: true,
                replace: true
            });
        }
    });
});