/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.security;

import java.util.Collection;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.statemachine.transition.Transition;

public class TransitionVoter<S, E>
implements AccessDecisionVoter<Transition<S, E>> {
    private String transitionSourcePrefix = "TRANSITION_SOURCE_";
    private String transitionTargetPrefix = "TRANSITION_TARGET_";

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && (attribute.getAttribute().startsWith(this.getTransitionSourcePrefix()) || attribute.getAttribute().startsWith(this.getTransitionTargetPrefix()));
    }

    public boolean supports(Class<?> clazz) {
        return Transition.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Transition<S, E> transition, Collection<ConfigAttribute> attributes) {
        int result = 0;
        if (authentication == null) {
            return result;
        }
        S source = transition.getSource().getId();
        S target = transition.getTarget().getId();
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            result = -1;
            String attr = attribute.getAttribute();
            if (attr.startsWith(this.getTransitionSourcePrefix()) && attr.equals(this.getTransitionSourcePrefix() + source.toString())) {
                return 1;
            }
            if (!attr.startsWith(this.getTransitionTargetPrefix()) || !attr.equals(this.getTransitionTargetPrefix() + target.toString())) continue;
            return 1;
        }
        return result;
    }

    public String getTransitionSourcePrefix() {
        return this.transitionSourcePrefix;
    }

    public void setTransitionSourcePrefix(String transitionSourcePrefix) {
        this.transitionSourcePrefix = transitionSourcePrefix;
    }

    public String getTransitionTargetPrefix() {
        return this.transitionTargetPrefix;
    }

    public void setTransitionTargetPrefix(String transitionTargetPrefix) {
        this.transitionTargetPrefix = transitionTargetPrefix;
    }
}

