/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.listener;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.AbstractCompositeListener;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;

public class CompositeStateMachineListener<S, E>
extends AbstractCompositeListener<StateMachineListener<S, E>>
implements StateMachineListener<S, E> {
    private static final Log log = LogFactory.getLog(CompositeStateMachineListener.class);

    @Override
    public void stateChanged(State<S, E> from, State<S, E> to) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.stateChanged(from, to);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during stateChanged", e);
            }
        }
    }

    @Override
    public void stateEntered(State<S, E> state) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.stateEntered(state);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during stateEntered", e);
            }
        }
    }

    @Override
    public void stateExited(State<S, E> state) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.stateExited(state);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during stateExited", e);
            }
        }
    }

    @Override
    public void eventNotAccepted(Message<E> event) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.eventNotAccepted(event);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during eventNotAccepted", e);
            }
        }
    }

    @Override
    public void transition(Transition<S, E> transition) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.transition(transition);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during transition", e);
            }
        }
    }

    @Override
    public void transitionStarted(Transition<S, E> transition) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.transitionStarted(transition);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during transitionStarted", e);
            }
        }
    }

    @Override
    public void transitionEnded(Transition<S, E> transition) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.transitionEnded(transition);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during transitionEnded", e);
            }
        }
    }

    @Override
    public void stateMachineStarted(StateMachine<S, E> stateMachine) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.stateMachineStarted(stateMachine);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during stateMachineStarted", e);
            }
        }
    }

    @Override
    public void stateMachineStopped(StateMachine<S, E> stateMachine) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.stateMachineStopped(stateMachine);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during stateMachineStopped", e);
            }
        }
    }

    @Override
    public void stateMachineError(StateMachine<S, E> stateMachine, Exception exception) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.stateMachineError(stateMachine, exception);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during stateMachineError", e);
            }
        }
    }

    @Override
    public void extendedStateChanged(Object key, Object value) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.extendedStateChanged(key, value);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during extendedStateChanged", e);
            }
        }
    }

    @Override
    public void stateContext(StateContext<S, E> stateContext) {
        Iterator iterator = this.getListeners().reverse();
        while (iterator.hasNext()) {
            StateMachineListener listener = (StateMachineListener)iterator.next();
            try {
                listener.stateContext(stateContext);
            }
            catch (Throwable e) {
                log.warn((Object)"Error during stateContext", e);
            }
        }
    }
}

