/**
 * This view renders list of recommendations
 */
define('jira/optimizer-plugin/recommendationsView', ['jira-optimizer-plugin/marionette-2.1.0', 'jira/optimizer-plugin/recommendationView', 'jira/optimizer-plugin/recommendationsCollection', 'jira/optimizer-plugin/paginationview', 'aui/flag'], function (Marionette, RecommendationView, RecommendationsCollection, Paginationview, Flag) {
    'use strict';

    return Marionette.CompositeView.extend({
        template: function template(data) {
            return CustomfieldAnalyzer.Templates.Recommendations(data);
        },
        templateContext: {},
        childView: RecommendationView,
        childViewContainer: 'tbody',
        ui: {
            paginationContainer: '#pagination-container'
        },
        initialize: function initialize(options) {
            var _this = this;

            this.paginator = new RecommendationsCollection([], {
                category: this.model.get('category')
            });

            this.collection = this.paginator;
            this.paginator.getFirstPage().done(this.render.bind(this)).fail(function () {
                _this.destroy();
                Flag({
                    type: 'error',
                    body: AJS.I18n.getText('optimizer.plugin.recommendation.load.failed.message')
                });
            });
        },
        onRender: function onRender() {
            this.paginationview = new Paginationview({
                collection: this.paginator
            });
            this.ui.paginationContainer.append(this.paginationview.render().el);
        },
        getNextPage: function getNextPage() {
            return this.paginator.getNextPage();
        }
    });
});