/**
 * Renders the summary of recommendations (Count, Severity etc of each category of recommendation)
 */
define('jira/optimizer-plugin/categoriesView', ['jira-optimizer-plugin/backbone-1.1.2', 'jira-optimizer-plugin/marionette-2.1.0', 'jira/optimizer-plugin/emptyCategoriesView', 'jira/optimizer-plugin/categoryView'], function (Backbone, Marionette, EmptyView, CategoryView) {
    'use strict';

    return Marionette.CollectionView.extend({
        tagName: 'ul',
        id: 'jgp-categories',
        childView: CategoryView,
        emptyView: EmptyView,
        // This is for passing the status information to empty view
        childViewOptions: function childViewOptions() {
            return {
                status: this.model.get('status')
            };
        },

        modelEvents: {
            'sync': 'statusUpdated'
        },
        /* When status view fetches status from the sever, it also includes the results.
         * so we use it to populate the collection instead of sending another request
         */
        statusUpdated: function statusUpdated(model, response) {
            this.collection.reset(response.values);
        }
    });
});