/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.model;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.statemachine.config.model.verifier.DefaultStateMachineModelVerifier;
import org.springframework.statemachine.config.model.verifier.StateMachineModelVerifier;
import org.springframework.statemachine.ensemble.StateMachineEnsemble;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.monitor.StateMachineMonitor;
import org.springframework.statemachine.security.SecurityRule;

public class ConfigurationData<S, E> {
    private final String machineId;
    private final BeanFactory beanFactory;
    private final TaskExecutor taskExecutor;
    private final TaskScheduler taskScheduler;
    private final boolean autoStart;
    private final StateMachineEnsemble<S, E> ensemble;
    private final List<StateMachineListener<S, E>> listeners;
    private final boolean securityEnabled;
    private final boolean verifierEnabled;
    private final StateMachineModelVerifier<S, E> verifier;
    private final AccessDecisionManager transitionSecurityAccessDecisionManager;
    private final AccessDecisionManager eventSecurityAccessDecisionManager;
    private final SecurityRule eventSecurityRule;
    private final SecurityRule transitionSecurityRule;
    private final StateMachineMonitor<S, E> stateMachineMonitor;

    public ConfigurationData() {
        this(null, (TaskExecutor)new SyncTaskExecutor(), (TaskScheduler)new ConcurrentTaskScheduler(), false, null, new ArrayList<StateMachineListener<S, E>>(), false, null, null, null, null, true, new DefaultStateMachineModelVerifier(), null, null);
    }

    public ConfigurationData(BeanFactory beanFactory, TaskExecutor taskExecutor, TaskScheduler taskScheduler, boolean autoStart, StateMachineEnsemble<S, E> ensemble, List<StateMachineListener<S, E>> listeners, boolean securityEnabled, AccessDecisionManager transitionSecurityAccessDecisionManager, AccessDecisionManager eventSecurityAccessDecisionManager, SecurityRule eventSecurityRule, SecurityRule transitionSecurityRule, boolean verifierEnabled, StateMachineModelVerifier<S, E> verifier, String machineId, StateMachineMonitor<S, E> stateMachineMonitor) {
        this.beanFactory = beanFactory;
        this.taskExecutor = taskExecutor;
        this.taskScheduler = taskScheduler;
        this.autoStart = autoStart;
        this.ensemble = ensemble;
        this.listeners = listeners;
        this.securityEnabled = securityEnabled;
        this.transitionSecurityAccessDecisionManager = transitionSecurityAccessDecisionManager;
        this.eventSecurityAccessDecisionManager = eventSecurityAccessDecisionManager;
        this.eventSecurityRule = eventSecurityRule;
        this.transitionSecurityRule = transitionSecurityRule;
        this.verifierEnabled = verifierEnabled;
        this.verifier = verifier;
        this.machineId = machineId;
        this.stateMachineMonitor = stateMachineMonitor;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public StateMachineEnsemble<S, E> getStateMachineEnsemble() {
        return this.ensemble;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public List<StateMachineListener<S, E>> getStateMachineListeners() {
        return this.listeners;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isVerifierEnabled() {
        return this.verifierEnabled;
    }

    public StateMachineModelVerifier<S, E> getVerifier() {
        return this.verifier;
    }

    public StateMachineMonitor<S, E> getStateMachineMonitor() {
        return this.stateMachineMonitor;
    }

    public AccessDecisionManager getTransitionSecurityAccessDecisionManager() {
        return this.transitionSecurityAccessDecisionManager;
    }

    public AccessDecisionManager getEventSecurityAccessDecisionManager() {
        return this.eventSecurityAccessDecisionManager;
    }

    public SecurityRule getEventSecurityRule() {
        return this.eventSecurityRule;
    }

    public SecurityRule getTransitionSecurityRule() {
        return this.transitionSecurityRule;
    }
}

