/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.model;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.model.DefaultStateMachineComponentResolver;
import org.springframework.statemachine.config.model.StateMachineComponentResolver;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.config.model.StateMachineModelFactory;
import org.springframework.statemachine.guard.Guard;
import org.springframework.util.Assert;

public abstract class AbstractStateMachineModelFactory<S, E>
implements StateMachineComponentResolver<S, E>,
StateMachineModelFactory<S, E>,
BeanFactoryAware,
ResourceLoaderAware {
    private BeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private StateMachineComponentResolver<S, E> stateMachineComponentResolver;
    private final DefaultStateMachineComponentResolver<S, E> internalResolver = new DefaultStateMachineComponentResolver();

    public AbstractStateMachineModelFactory() {
    }

    public AbstractStateMachineModelFactory(ResourceLoader resourceLoader, StateMachineComponentResolver<S, E> stateMachineComponentResolver) {
        this.resourceLoader = resourceLoader;
        this.stateMachineComponentResolver = stateMachineComponentResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.internalResolver.setBeanFactory(beanFactory);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"resourceLoader cannot be null");
        this.resourceLoader = resourceLoader;
    }

    @Override
    public StateMachineModel<S, E> build(String machineId) {
        return this.build();
    }

    @Override
    public abstract StateMachineModel<S, E> build();

    public void setStateMachineComponentResolver(StateMachineComponentResolver<S, E> stateMachineComponentResolver) {
        this.stateMachineComponentResolver = stateMachineComponentResolver;
    }

    public void registerAction(String id, Action<S, E> action) {
        this.internalResolver.registerAction(id, action);
    }

    public void registerGuard(String id, Guard<S, E> guard) {
        this.internalResolver.registerGuard(id, guard);
    }

    public StateMachineComponentResolver<S, E> getStateMachineComponentResolver() {
        return this.stateMachineComponentResolver;
    }

    @Override
    public Action<S, E> resolveAction(String id) {
        Action<S, E> a = this.internalResolver.resolveAction(id);
        if (a == null && this.stateMachineComponentResolver != null) {
            a = this.stateMachineComponentResolver.resolveAction(id);
        }
        if (a == null) {
            throw new RuntimeException("Can't resolve action with id " + id + " either from registered actions nor beanfactory");
        }
        return a;
    }

    @Override
    public Guard<S, E> resolveGuard(String id) {
        Guard<S, E> a = this.internalResolver.resolveGuard(id);
        if (a == null && this.stateMachineComponentResolver != null) {
            a = this.stateMachineComponentResolver.resolveGuard(id);
        }
        if (a == null) {
            throw new RuntimeException("Can't resolve guard with id " + id + " either from registered guards nor beanfactory");
        }
        return a;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

