/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.common.annotation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.GenericTypeResolver;
import org.springframework.statemachine.config.common.annotation.AnnotationBuilder;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurer;
import org.springframework.statemachine.config.common.annotation.ObjectPostProcessor;

public abstract class AnnotationConfigurerAdapter<O, I, B extends AnnotationBuilder<O>>
implements AnnotationConfigurer<O, B> {
    private B builder;
    private CompositeObjectPostProcessor objectPostProcessor = new CompositeObjectPostProcessor();

    @Override
    public void init(B builder) throws Exception {
    }

    @Override
    public void configure(B builder) throws Exception {
    }

    public I and() {
        return (I)this.getBuilder();
    }

    protected final B getBuilder() {
        if (this.builder == null) {
            throw new IllegalStateException("annotationBuilder cannot be null");
        }
        return this.builder;
    }

    public void addObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.objectPostProcessor.addObjectPostProcessor(objectPostProcessor);
    }

    public void setBuilder(B builder) {
        this.builder = builder;
    }

    @Override
    public boolean isAssignable(AnnotationBuilder<O> builder) {
        return true;
    }

    private static final class CompositeObjectPostProcessor
    implements ObjectPostProcessor<Object> {
        private List<ObjectPostProcessor<? extends Object>> postProcessors = new ArrayList<ObjectPostProcessor<? extends Object>>();

        private CompositeObjectPostProcessor() {
        }

        @Override
        public Object postProcess(Object object) {
            for (ObjectPostProcessor<? extends Object> opp : this.postProcessors) {
                Class<?> oppClass = opp.getClass();
                Class oppType = GenericTypeResolver.resolveTypeArgument(oppClass, ObjectPostProcessor.class);
                if (oppType != null && !oppType.isAssignableFrom(object.getClass())) continue;
                object = opp.postProcess(object);
            }
            return object;
        }

        private boolean addObjectPostProcessor(ObjectPostProcessor<? extends Object> objectPostProcessor) {
            return this.postProcessors.add(objectPostProcessor);
        }
    }
}

