/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.common.annotation;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.statemachine.config.common.annotation.AnnotationBuilder;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractImportingAnnotationConfiguration<B extends AnnotationBuilder<O>, O>
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware,
EnvironmentAware {
    private BeanFactory beanFactory;
    private Environment environment;
    private final BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        BeanDefinition beanDefinition;
        AnnotationAttributes scopeAttributes;
        List<Class<Annotation>> annotationTypes = this.getAnnotations();
        Class<Annotation> namedAnnotation = null;
        String[] names = null;
        ScopedProxyMode proxyMode = null;
        if (annotationTypes != null) {
            for (Class<Annotation> annotationType : annotationTypes) {
                AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(annotationType.getName(), false));
                if (attributes == null || !attributes.containsKey((Object)"name")) continue;
                names = attributes.getStringArray("name");
                namedAnnotation = annotationType;
                break;
            }
        }
        if ((scopeAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(Scope.class.getName(), false))) != null) {
            proxyMode = (ScopedProxyMode)scopeAttributes.getEnum("proxyMode");
        }
        try {
            beanDefinition = this.buildBeanDefinition(importingClassMetadata, namedAnnotation);
        }
        catch (Exception e) {
            throw new RuntimeException("Error with onConfigurers", e);
        }
        if (beanDefinition == null) {
            return;
        }
        if (ObjectUtils.isEmpty(names)) {
            names = new String[]{this.beanNameGenerator.generateBeanName(beanDefinition, registry)};
        }
        registry.registerBeanDefinition((String)names[0], beanDefinition);
        if (names.length > 1) {
            for (int i = 1; i < names.length; ++i) {
                registry.registerAlias(names[0], names[i]);
            }
        }
        if (proxyMode != null && proxyMode != ScopedProxyMode.DEFAULT && proxyMode != ScopedProxyMode.NO) {
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(beanDefinition, names[0]);
            BeanDefinitionHolder scopedProxy = null;
            if (proxyMode == ScopedProxyMode.TARGET_CLASS) {
                scopedProxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry, (boolean)true);
            } else if (proxyMode == ScopedProxyMode.INTERFACES) {
                scopedProxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry, (boolean)false);
            } else {
                throw new IllegalArgumentException("Unknown proxyMode " + proxyMode);
            }
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)scopedProxy, (BeanDefinitionRegistry)registry);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ListableBeanFactory.class, (Object)beanFactory, (String)("beanFactory be of type ListableBeanFactory but was " + beanFactory));
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected abstract BeanDefinition buildBeanDefinition(AnnotationMetadata var1, Class<? extends Annotation> var2) throws Exception;

    protected abstract List<Class<? extends Annotation>> getAnnotations();

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected static abstract class BeanDelegatingFactoryBean<T, B extends AnnotationBuilder<O>, O>
    implements FactoryBean<T>,
    BeanFactoryAware,
    InitializingBean,
    DisposableBean {
        private final B builder;
        private T object;
        private List<AnnotationConfigurer<O, B>> configurers;
        private BeanFactory beanFactory;
        private Class<T> clazz;

        public BeanDelegatingFactoryBean(B builder, Class<T> clazz) {
            this.builder = builder;
            this.clazz = clazz;
        }

        public Class<?> getObjectType() {
            return this.clazz;
        }

        public T getObject() throws Exception {
            return this.object;
        }

        public boolean isSingleton() {
            return true;
        }

        @Autowired(required=false)
        public void setConfigurers(List<AnnotationConfigurer<O, B>> configurers) {
            this.configurers = configurers;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public void destroy() throws Exception {
        }

        public B getBuilder() {
            return this.builder;
        }

        public List<AnnotationConfigurer<O, B>> getConfigurers() {
            return this.configurers;
        }

        protected void setObject(T object) {
            this.object = object;
        }

        protected BeanFactory getBeanFactory() {
            return this.beanFactory;
        }
    }
}

