/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.common.annotation.AbstractConfiguredAnnotationBuilder;
import org.springframework.statemachine.config.common.annotation.ObjectPostProcessor;
import org.springframework.statemachine.config.configurers.ChoiceTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultChoiceTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultEntryTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultExitTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultExternalTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultForkTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultHistoryTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultInternalTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultJoinTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultJunctionTransitionConfigurer;
import org.springframework.statemachine.config.configurers.DefaultLocalTransitionConfigurer;
import org.springframework.statemachine.config.configurers.EntryTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExitTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ForkTransitionConfigurer;
import org.springframework.statemachine.config.configurers.HistoryTransitionConfigurer;
import org.springframework.statemachine.config.configurers.InternalTransitionConfigurer;
import org.springframework.statemachine.config.configurers.JoinTransitionConfigurer;
import org.springframework.statemachine.config.configurers.JunctionTransitionConfigurer;
import org.springframework.statemachine.config.configurers.LocalTransitionConfigurer;
import org.springframework.statemachine.config.model.ChoiceData;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.config.model.EntryData;
import org.springframework.statemachine.config.model.ExitData;
import org.springframework.statemachine.config.model.HistoryData;
import org.springframework.statemachine.config.model.JunctionData;
import org.springframework.statemachine.config.model.TransitionData;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.security.SecurityRule;
import org.springframework.statemachine.transition.TransitionKind;

public class StateMachineTransitionBuilder<S, E>
extends AbstractConfiguredAnnotationBuilder<TransitionsData<S, E>, StateMachineTransitionConfigurer<S, E>, StateMachineTransitionBuilder<S, E>>
implements StateMachineTransitionConfigurer<S, E> {
    private final Collection<TransitionData<S, E>> transitionData = new ArrayList<TransitionData<S, E>>();
    private final Map<S, List<ChoiceData<S, E>>> choices = new HashMap<S, List<ChoiceData<S, E>>>();
    private final Map<S, List<JunctionData<S, E>>> junctions = new HashMap<S, List<JunctionData<S, E>>>();
    private final Map<S, List<S>> forks = new HashMap<S, List<S>>();
    private final Map<S, List<S>> joins = new HashMap<S, List<S>>();
    private final Collection<EntryData<S, E>> entryData = new ArrayList<EntryData<S, E>>();
    private final Collection<ExitData<S, E>> exitData = new ArrayList<ExitData<S, E>>();
    private final Collection<HistoryData<S, E>> historyData = new ArrayList<HistoryData<S, E>>();

    public StateMachineTransitionBuilder() {
    }

    public StateMachineTransitionBuilder(ObjectPostProcessor<Object> objectPostProcessor, boolean allowConfigurersOfSameType) {
        super(objectPostProcessor, allowConfigurersOfSameType);
    }

    public StateMachineTransitionBuilder(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    @Override
    protected TransitionsData<S, E> performBuild() throws Exception {
        return new TransitionsData<S, E>(this.transitionData, this.choices, this.junctions, this.forks, this.joins, this.entryData, this.exitData, this.historyData);
    }

    @Override
    public ExternalTransitionConfigurer<S, E> withExternal() throws Exception {
        return this.apply(new DefaultExternalTransitionConfigurer());
    }

    @Override
    public InternalTransitionConfigurer<S, E> withInternal() throws Exception {
        return this.apply(new DefaultInternalTransitionConfigurer());
    }

    @Override
    public LocalTransitionConfigurer<S, E> withLocal() throws Exception {
        return this.apply(new DefaultLocalTransitionConfigurer());
    }

    @Override
    public ChoiceTransitionConfigurer<S, E> withChoice() throws Exception {
        return this.apply(new DefaultChoiceTransitionConfigurer());
    }

    @Override
    public JunctionTransitionConfigurer<S, E> withJunction() throws Exception {
        return this.apply(new DefaultJunctionTransitionConfigurer());
    }

    @Override
    public ForkTransitionConfigurer<S, E> withFork() throws Exception {
        return this.apply(new DefaultForkTransitionConfigurer());
    }

    @Override
    public JoinTransitionConfigurer<S, E> withJoin() throws Exception {
        return this.apply(new DefaultJoinTransitionConfigurer());
    }

    @Override
    public EntryTransitionConfigurer<S, E> withEntry() throws Exception {
        return this.apply(new DefaultEntryTransitionConfigurer());
    }

    @Override
    public ExitTransitionConfigurer<S, E> withExit() throws Exception {
        return this.apply(new DefaultExitTransitionConfigurer());
    }

    @Override
    public HistoryTransitionConfigurer<S, E> withHistory() throws Exception {
        return this.apply(new DefaultHistoryTransitionConfigurer());
    }

    public void addTransition(S source, S target, S state, E event, Long period, Integer count, Collection<Action<S, E>> actions, Guard<S, E> guard, TransitionKind kind, SecurityRule securityRule) {
        if (securityRule == null) {
            ConfigurationData config = this.getSharedObject(ConfigurationData.class);
            securityRule = config.getTransitionSecurityRule();
        }
        this.transitionData.add(new TransitionData<S, E>(source, target, state, event, period, count, actions, guard, kind, securityRule));
    }

    public void addChoice(S source, List<ChoiceData<S, E>> choices) {
        this.choices.put(source, choices);
    }

    public void addJunction(S source, List<JunctionData<S, E>> junctions) {
        this.junctions.put(source, junctions);
    }

    public void addEntry(S source, S target) {
        this.entryData.add(new EntryData(source, target));
    }

    public void addExit(S source, S target) {
        this.exitData.add(new ExitData(source, target));
    }

    public void addFork(S source, List<S> targets) {
        this.forks.put(source, targets);
    }

    public void addJoin(S target, List<S> sources) {
        this.joins.put(target, sources);
    }

    public void addDefaultHistory(S source, S target) {
        this.historyData.add(new HistoryData(source, target));
    }
}

