/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl.recommendations;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.optimizer.api.RecommendationProvider;
import com.atlassian.jira.optimizer.beans.RecommendationBean;
import com.atlassian.jira.optimizer.impl.RecommendationCategory;
import com.atlassian.jira.optimizer.impl.recommendations.CustomFieldsProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LocaliseCfProjectsRecommendationProvider
implements RecommendationProvider {
    public static final Logger log = LoggerFactory.getLogger(LocaliseCfProjectsRecommendationProvider.class);
    private final ProjectManager projectManager;
    private final CustomFieldsProvider customFieldsProvider;

    @Inject
    public LocaliseCfProjectsRecommendationProvider(@ComponentImport ProjectManager projectManager, CustomFieldsProvider customFieldsProvider) {
        this.projectManager = projectManager;
        this.customFieldsProvider = customFieldsProvider;
    }

    @Override
    public List<Supplier<Collection<RecommendationBean>>> createTasks() {
        return this.customFieldsProvider.getListOfLocalisableCustomFields().stream().map(this::getRecommendationSupplier).collect(Collectors.toList());
    }

    private Supplier<Collection<RecommendationBean>> getRecommendationSupplier(CustomField customField) {
        return () -> {
            try {
                return this.getRecommendations(customField);
            }
            catch (Exception e) {
                log.warn("Exception during getting recommendations for Custom Feild " + customField, (Throwable)e);
                return Collections.emptyList();
            }
        };
    }

    private Collection<RecommendationBean> getRecommendations(CustomField customField) {
        if (!this.customFieldsProvider.canBeLocalised(customField)) {
            return Collections.emptyList();
        }
        List<Long> projectIds = this.customFieldsProvider.getListOfProjectsUsingCF(customField);
        if (projectIds.size() > 10) {
            return Collections.emptyList();
        }
        List<Project> projects = projectIds.stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).collect(Collectors.toList());
        List<Project> affectedProjects = this.customFieldsProvider.filterProjectsWithLocalContexts(customField, projects);
        double impact = this.customFieldsProvider.getImpactOfLocalizingCustomField(customField, new HashSet<Project>(affectedProjects));
        return ImmutableList.of((Object)new RecommendationBean(RecommendationCategory.LOCALIZE_CONTEXT.getCategoryName() + "-" + customField.getIdAsLong(), customField.getName(), RecommendationCategory.LOCALIZE_CONTEXT.getCategoryName(), customField.getIdAsLong(), this.toIds(affectedProjects), customField.getCustomFieldType().getName(), impact));
    }

    private List<Long> toIds(Collection<Project> projects) {
        return projects.stream().map(Project::getId).collect(Collectors.toList());
    }
}

