/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl.actions;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.optimizer.beans.RecommendationBean;
import com.atlassian.jira.optimizer.impl.ArchivedProjectSearcher;
import com.atlassian.jira.optimizer.impl.RecommendationCategory;
import com.atlassian.jira.optimizer.impl.actions.Action;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LocalizeCfAction
implements Action {
    private static final Logger log = LoggerFactory.getLogger(LocalizeCfAction.class);
    private final CustomFieldManager customFieldManager;
    private final ProjectManager projectManager;
    private final ArchivedProjectSearcher archivedProjectSearcher;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    @Inject
    public LocalizeCfAction(@ComponentImport CustomFieldManager customFieldManager, @ComponentImport ProjectManager projectManager, ArchivedProjectSearcher archivedProjectSearcher, @ComponentImport FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.customFieldManager = customFieldManager;
        this.projectManager = projectManager;
        this.archivedProjectSearcher = archivedProjectSearcher;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @Override
    public String getRecommendationCategory() {
        return RecommendationCategory.LOCALIZE_CONTEXT.getCategoryName();
    }

    @Override
    public void applyRecommendation(RecommendationBean recommendationBean) {
        if (!this.getRecommendationCategory().equals(recommendationBean.getCategory())) {
            throw new IllegalArgumentException(String.format("Error while applying recommendation '%s': Unsupported recommendation type.\nExpected '%s'\nActual '%s'", recommendationBean, this.getRecommendationCategory(), recommendationBean.getCategory()));
        }
        CustomField customField = Objects.requireNonNull(this.customFieldManager.getCustomFieldObject(recommendationBean.getCustomFieldId()));
        List<Long> projectIds = Objects.requireNonNull(recommendationBean.getProjectIds());
        projectIds.addAll(this.archivedProjectSearcher.getArchivedProjectsUsingCf(customField));
        this.localize(customField, projectIds);
    }

    private void localize(CustomField customField, List<Long> projectIds) {
        FieldConfigScheme globalContext = customField.getConfigurationSchemes().stream().filter(FieldConfigScheme::isAllProjects).findAny().orElseThrow(() -> new RuntimeException("Couldn't find global context for '" + customField.getName() + "'(" + customField.getId() + ")"));
        if (projectIds.isEmpty()) {
            log.info("Removing global context '{}' of {}(#{})", new Object[]{globalContext.getName(), customField.getFieldName(), customField.getId()});
            this.fieldConfigSchemeManager.removeFieldConfigScheme(globalContext.getId());
        } else {
            log.info("Shrinking global context '{}' of {}(#{}) to {} projects", new Object[]{globalContext.getName(), customField.getFieldName(), customField.getId(), projectIds.size()});
            FieldConfigScheme updatedScheme = this.changeSchemeDescription(globalContext);
            List jiraContextNodes = CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])projectIds.toArray(new Long[0]), (ProjectManager)this.projectManager);
            this.fieldConfigSchemeManager.updateFieldConfigScheme(updatedScheme, jiraContextNodes, (ConfigurableField)customField);
        }
    }

    private FieldConfigScheme changeSchemeDescription(FieldConfigScheme globalContext) {
        return new FieldConfigScheme.Builder(globalContext).setDescription("[Optimized by Custom Field Optimizer] " + globalContext.getDescription()).toFieldConfigScheme();
    }
}

