/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.action;

import com.atlassian.jira.optimizer.beans.RecommendationBean;
import com.atlassian.jira.optimizer.impl.RecommendationsManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

@WebSudoRequired
public class UsedByProjects
extends JiraWebActionSupport {
    private final PageBuilderService pageBuilder;
    private final RecommendationsManager recommendationsManager;
    private final ProjectManager projectManager;
    private String recommendationId;
    private RecommendationBean recommendation;

    @Inject
    public UsedByProjects(@ComponentImport PageBuilderService pageBuilder, RecommendationsManager recommendationsManager, @ComponentImport ProjectManager projectManager) {
        this.pageBuilder = pageBuilder;
        this.recommendationsManager = recommendationsManager;
        this.projectManager = projectManager;
    }

    public void doValidation() {
        this.processResources();
    }

    @ActionViewData
    public List<Project> getUsedByProjects() {
        List<Long> projectIds = this.getRecommendation().getProjectIds();
        return projectIds.stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).collect(Collectors.toList());
    }

    @ActionViewData
    public RecommendationBean getRecommendation() {
        if (this.recommendation == null) {
            this.recommendation = this.recommendationsManager.getRecommendation(this.recommendationId);
        }
        return this.recommendation;
    }

    protected void processResources() {
        this.pageBuilder.assembler().resources().requireWebResource("com.atlassian.jira.plugins.jira-optimizer-plugin:jira-optimizer-used-by-projects");
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }
}

