/**
 * Renders the welcome state of the plugin
 */
define('jira/optimizer-plugin/welcomeView', ['jira-optimizer-plugin/marionette-2.1.0'], function (Marionette) {
    'use strict';

    return Marionette.ItemView.extend({
        template: CustomfieldAnalyzer.Templates.welcomeState,
        id: 'jgp-welcome-state',
        ui: {
            scanButton: '#jgp-welcome-scan'
        },
        events: {
            'click @ui.scanButton': 'initializeScan'
        },
        initializeScan: function initializeScan() {
            this.ui.scanButton.prop('disabled', true);
            this.model.save().done(function () {
                Backbone.history.navigate('', {
                    trigger: true,
                    replace: true
                });
            });
        }
    });
});