/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.statemachine.annotation.OnEventNotAccepted;
import org.springframework.statemachine.annotation.OnExtendedStateChanged;
import org.springframework.statemachine.annotation.OnStateChanged;
import org.springframework.statemachine.annotation.OnStateEntry;
import org.springframework.statemachine.annotation.OnStateExit;
import org.springframework.statemachine.annotation.OnStateMachineError;
import org.springframework.statemachine.annotation.OnStateMachineStart;
import org.springframework.statemachine.annotation.OnStateMachineStop;
import org.springframework.statemachine.annotation.OnTransition;
import org.springframework.statemachine.annotation.OnTransitionEnd;
import org.springframework.statemachine.annotation.OnTransitionStart;
import org.springframework.statemachine.annotation.WithStateMachine;
import org.springframework.statemachine.processor.MethodAnnotationPostProcessor;
import org.springframework.statemachine.processor.StateMachineActivatorAnnotationPostProcessor;
import org.springframework.statemachine.processor.StateMachineHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class StateMachineAnnotationPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
Lifecycle,
ApplicationListener<ApplicationEvent> {
    private static final Log log = LogFactory.getLog(StateMachineAnnotationPostProcessor.class);
    private volatile ConfigurableListableBeanFactory beanFactory;
    private final Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> postProcessors = new HashMap();
    private final Set<ApplicationListener<ApplicationEvent>> listeners = new HashSet<ApplicationListener<ApplicationEvent>>();
    private final Set<Lifecycle> lifecycles = new HashSet<Lifecycle>();
    private volatile boolean running = true;

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isAssignable(ConfigurableListableBeanFactory.class, beanFactory.getClass(), (String)"a ConfigurableListableBeanFactory is required");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        this.postProcessors.put(OnTransition.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnTransitionStart.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnTransitionEnd.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnStateChanged.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnStateEntry.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnStateExit.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnStateMachineStart.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnStateMachineStop.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnEventNotAccepted.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnStateMachineError.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(OnExtendedStateChanged.class, new StateMachineActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        final Class<?> beanClass = this.getBeanClass(bean);
        if (AnnotationUtils.findAnnotation(beanClass, WithStateMachine.class) == null) {
            return bean;
        }
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                for (Class ppa : StateMachineAnnotationPostProcessor.this.postProcessors.keySet()) {
                    Annotation metaAnnotation = AnnotationUtils.findAnnotation((Method)method, (Class)ppa);
                    if (metaAnnotation == null) continue;
                    for (Annotation a : AnnotationUtils.getAnnotations((Method)method)) {
                        Object result;
                        MethodAnnotationPostProcessor postProcessor;
                        MethodAnnotationPostProcessor methodAnnotationPostProcessor = postProcessor = metaAnnotation != null ? (MethodAnnotationPostProcessor)StateMachineAnnotationPostProcessor.this.postProcessors.get(metaAnnotation.annotationType()) : null;
                        if (postProcessor == null || !StateMachineAnnotationPostProcessor.this.shouldCreateHandler(a) || (result = postProcessor.postProcess(beanClass, bean, beanName, method, metaAnnotation, a)) == null || !(result instanceof StateMachineHandler)) continue;
                        String endpointBeanName = StateMachineAnnotationPostProcessor.this.generateBeanName(beanName, method, a.annotationType());
                        if (result instanceof BeanNameAware) {
                            ((BeanNameAware)result).setBeanName(endpointBeanName);
                        }
                        StateMachineAnnotationPostProcessor.this.beanFactory.registerSingleton(endpointBeanName, result);
                        if (result instanceof BeanFactoryAware) {
                            ((BeanFactoryAware)result).setBeanFactory((BeanFactory)StateMachineAnnotationPostProcessor.this.beanFactory);
                        }
                        if (result instanceof InitializingBean) {
                            try {
                                ((InitializingBean)result).afterPropertiesSet();
                            }
                            catch (Exception e) {
                                throw new BeanInitializationException("failed to initialize annotated component", (Throwable)e);
                            }
                        }
                        if (result instanceof Lifecycle) {
                            StateMachineAnnotationPostProcessor.this.lifecycles.add((Lifecycle)result);
                            if (result instanceof SmartLifecycle && ((SmartLifecycle)result).isAutoStartup()) {
                                ((SmartLifecycle)result).start();
                            }
                        }
                        if (!(result instanceof ApplicationListener)) continue;
                        StateMachineAnnotationPostProcessor.this.listeners.add((ApplicationListener)result);
                    }
                }
            }
        });
        return bean;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        for (ApplicationListener<ApplicationEvent> listener : this.listeners) {
            try {
                listener.onApplicationEvent(event);
            }
            catch (ClassCastException e) {
                if (!log.isWarnEnabled() || event == null) continue;
                log.warn((Object)("ApplicationEvent of type [" + event.getClass() + "] not accepted by ApplicationListener [" + listener + "]"));
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        for (Lifecycle lifecycle : this.lifecycles) {
            if (lifecycle.isRunning()) continue;
            lifecycle.start();
        }
        this.running = true;
    }

    public void stop() {
        for (Lifecycle lifecycle : this.lifecycles) {
            if (!lifecycle.isRunning()) continue;
            lifecycle.stop();
        }
        this.running = false;
    }

    private boolean shouldCreateHandler(Annotation annotation) {
        return true;
    }

    private Class<?> getBeanClass(Object bean) {
        Class<?> targetClass = AopUtils.getTargetClass((Object)bean);
        return targetClass != null ? targetClass : bean.getClass();
    }

    private String generateBeanName(String originalBeanName, Method method, Class<? extends Annotation> annotationType) {
        String baseName;
        String name = baseName = originalBeanName + "." + method.getName() + "." + ClassUtils.getShortNameAsProperty(annotationType);
        int count = 1;
        while (this.beanFactory.containsBean(name)) {
            name = baseName + "#" + ++count;
        }
        return name;
    }
}

