/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.rest;

import com.atlassian.jira.optimizer.api.OptimizerService;
import com.atlassian.jira.optimizer.api.RecommendationGenerationStatus;
import com.atlassian.jira.optimizer.beans.RecommendationBean;
import com.atlassian.jira.optimizer.beans.RecommendationsBean;
import com.atlassian.jira.optimizer.impl.actions.ActionManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json"})
@Named
public class OptimizerResource {
    private static final Logger log = LoggerFactory.getLogger(OptimizerResource.class);
    private final OptimizerService optimizerService;
    private final ActionManager actionManager;

    @Inject
    public OptimizerResource(OptimizerService optimizerService, ActionManager actionManager) {
        this.optimizerService = optimizerService;
        this.actionManager = actionManager;
    }

    @Path(value="recommendations")
    @GET
    @Produces(value={"application/json"})
    @WebSudoRequired
    public Response getRecommendations(@DefaultValue(value="1") @QueryParam(value="startAt") int startAtPage, @DefaultValue(value="25") @QueryParam(value="maxResults") int maxResults, @QueryParam(value="category") String category) {
        log.info("Call getRecommendations with params: {}, {}, {}", new Object[]{startAtPage, maxResults, category});
        if (this.optimizerService.getStatus() != RecommendationGenerationStatus.DONE) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<RecommendationBean> allRecommendations = this.optimizerService.getRecommendations(category);
        if (startAtPage < 1 || maxResults < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        long offset = --startAtPage * maxResults;
        List<RecommendationBean> filteredRecommendations = allRecommendations.stream().skip(offset).limit(maxResults).collect(Collectors.toList());
        return Response.ok((Object)new RecommendationsBean(startAtPage, maxResults, allRecommendations.size(), filteredRecommendations)).build();
    }

    @Path(value="recommendations/info")
    @POST
    @WebSudoRequired
    public Response refresh() {
        log.info("Call refresh");
        this.optimizerService.refreshRecommendations();
        return Response.ok((Object)this.optimizerService.getRecommendationsInfo()).build();
    }

    @Path(value="recommendations/stop")
    @POST
    public void stop() {
        this.optimizerService.stop();
    }

    @Path(value="recommendations/info")
    @GET
    @Produces(value={"application/json"})
    @WebSudoRequired
    public Response getRecommendationsInfo() {
        log.info("Call getRecommendationsInfo");
        return Response.ok((Object)this.optimizerService.getRecommendationsInfo()).build();
    }

    @Path(value="/recommendation/{id}")
    @PUT
    @WebSudoRequired
    public Response applyRecommendation(@PathParam(value="id") String recommendationId) {
        log.info("Call applyRecommendation with id: {}", (Object)recommendationId);
        try {
            this.actionManager.applyRecommendation(recommendationId);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("Error while applying recommendation with id {}", (Object)recommendationId, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

