/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl.recommendations;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.optimizer.impl.CustomFieldsBlackList;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldsProvider {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldsProvider.class);
    private final CustomFieldManager customFieldManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory searchProviderFactory;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final CustomFieldsBlackList customFieldsBlackList;
    private final ProjectManager projectManager;

    @Inject
    public CustomFieldsProvider(@ComponentImport CustomFieldManager customFieldManager, @ComponentImport SearchProvider searchProvider, @ComponentImport SearchProviderFactory searchProviderFactory, @ComponentImport ManagedConfigurationItemService managedConfigurationItemService, CustomFieldsBlackList customFieldsBlackList, @ComponentImport ProjectManager projectManager) {
        this.customFieldManager = customFieldManager;
        this.searchProvider = searchProvider;
        this.searchProviderFactory = searchProviderFactory;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.customFieldsBlackList = customFieldsBlackList;
        this.projectManager = projectManager;
    }

    public List<CustomField> getListOfLocalisableCustomFields() {
        return this.customFieldManager.getCustomFieldObjects().stream().filter(this::canBeLocalised).filter(cf -> cf.getCustomFieldSearcher() != null).collect(Collectors.toList());
    }

    public List<Long> getListOfProjectsUsingCF(CustomField customField) {
        log.debug("Getting projects with values for custom fields {}", (Object)customField.getId());
        return this.getListOfProjects(JqlQueryBuilder.newBuilder().where().customField(customField.getIdAsLong()).isNotEmpty().buildQuery());
    }

    public List<Long> getListOfProjects(Query query) {
        return this.getListOfProjects((ProjectIdCollector projectIdCollector) -> {
            try {
                this.searchProvider.searchOverrideSecurity(query, null, (Collector)projectIdCollector);
            }
            catch (SearchException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public List<Long> getListOfProjects(org.apache.lucene.search.Query query) {
        return this.getListOfProjects((ProjectIdCollector projectIdCollector) -> {
            try {
                this.searchProviderFactory.getSearcher("issues").search(query, (Collector)projectIdCollector);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<Long> getListOfProjects(Consumer<ProjectIdCollector> searcher) {
        Instant startTime = Instant.now();
        ProjectIdCollector projectIdCollector = new ProjectIdCollector();
        searcher.accept(projectIdCollector);
        Set<Long> projectsWithNonEmptyCfs = projectIdCollector.getProjectIds();
        log.debug("Got a list of {} projects in {}ms", (Object)projectsWithNonEmptyCfs.size(), (Object)Duration.between(startTime, Instant.now()).toMillis());
        return ImmutableList.copyOf(projectsWithNonEmptyCfs);
    }

    public List<Project> filterProjectsWithLocalContexts(CustomField customField, List<Project> projects) {
        Set concreteContexts = customField.getConfigurationSchemes().stream().filter(scheme -> !scheme.isAllProjects()).flatMap(s -> s.getAssociatedProjectObjects().stream()).collect(Collectors.toSet());
        return projects.stream().filter(p -> !concreteContexts.contains(p)).collect(Collectors.toList());
    }

    public boolean canBeLocalised(CustomField customField) {
        return !this.isSystemField(customField) && customField.isAllProjects() && !this.customFieldsBlackList.isTreatedAsSystem(customField);
    }

    private boolean isSystemField(CustomField customField) {
        return this.managedConfigurationItemService.getManagedCustomField(customField).isManaged();
    }

    double getImpactOfLocalizingCustomField(CustomField customField, Set<Project> localizeToThoseProjects) {
        long numberOfIssuesToBeFreed = this.getNumberOfIssuesToBeFreed(customField, localizeToThoseProjects);
        if (numberOfIssuesToBeFreed == 0L) {
            return 1.0;
        }
        long totalIssuesCount = this.queryTotalIssuesCount();
        return Double.min(1.0, (double)numberOfIssuesToBeFreed / (double)totalIssuesCount);
    }

    private long getNumberOfIssuesToBeFreed(CustomField customField, Set<Project> localizeToThoseProjects) {
        Optional<FieldConfigScheme> globalFieldConfigScheme = customField.getConfigurationSchemes().stream().filter(FieldConfigScheme::isAllProjects).findAny();
        if (globalFieldConfigScheme.isPresent()) {
            Set currentProjectsInLocalContext = customField.getConfigurationSchemes().stream().filter(scheme -> !scheme.isAllProjects()).map(FieldConfigScheme::getAssociatedProjectObjects).flatMap(Collection::stream).collect(Collectors.toSet());
            List currentProjectsInGlobalContext = this.projectManager.getProjects().stream().filter(p -> !currentProjectsInLocalContext.contains(p)).collect(Collectors.toList());
            List projectsToBeFreed = currentProjectsInGlobalContext.stream().filter(p -> !localizeToThoseProjects.contains(p)).collect(Collectors.toList());
            if (projectsToBeFreed.isEmpty()) {
                return 0L;
            }
            JqlClauseBuilder jqlClauseBuilder = JqlQueryBuilder.newBuilder().where().project((Long[])projectsToBeFreed.stream().map(Project::getId).toArray(Long[]::new));
            if (!globalFieldConfigScheme.get().isAllIssueTypes()) {
                jqlClauseBuilder = jqlClauseBuilder.and().issueType((String[])globalFieldConfigScheme.get().getAssociatedIssueTypes().stream().map(issueType -> issueType.getId()).toArray(String[]::new));
            }
            try {
                return this.searchProvider.searchCountOverrideSecurity(jqlClauseBuilder.buildQuery(), null);
            }
            catch (SearchException e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("Counting issues works only if configuration scheme has global context");
    }

    private long queryTotalIssuesCount() {
        return this.searchProviderFactory.getSearcher("issues").getIndexReader().numDocs();
    }

    private static class ProjectIdCollector
    extends Collector {
        private final Set<Long> projectIds = new HashSet<Long>();
        private String[] docIdToProjectId;

        private ProjectIdCollector() {
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int docId) throws IOException {
            this.projectIds.add(Long.valueOf(this.docIdToProjectId[docId]));
        }

        public void setNextReader(IndexReader reader, int i) throws IOException {
            this.docIdToProjectId = FieldCache.DEFAULT.getStrings(reader, "projid");
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public Set<Long> getProjectIds() {
            return this.projectIds;
        }
    }
}

