/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.support;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;

public class CountTrigger
implements Trigger {
    private final int count;
    private final long period;
    private final TimeUnit timeUnit;
    private volatile long initialDelay = 0L;
    private volatile boolean fixedRate = false;
    private volatile int counter = 0;

    public CountTrigger(long period) {
        this(1, period, null);
    }

    public CountTrigger(int count, long period, TimeUnit timeUnit) {
        this(count, period, 0L, timeUnit);
    }

    public CountTrigger(int count, long period, long initialDelay, TimeUnit timeUnit) {
        Assert.isTrue((period >= 0L ? 1 : 0) != 0, (String)"period must not be negative");
        Assert.isTrue((count >= 0 ? 1 : 0) != 0, (String)"count must not be negative");
        this.timeUnit = timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS;
        this.period = this.timeUnit.toMillis(period);
        this.count = count;
        this.setInitialDelay(initialDelay);
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = this.timeUnit.toMillis(initialDelay);
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        if (this.count > 0 && ++this.counter > this.count) {
            return null;
        }
        if (triggerContext.lastScheduledExecutionTime() == null) {
            return new Date(System.currentTimeMillis() + this.initialDelay);
        }
        if (this.fixedRate) {
            return new Date(triggerContext.lastScheduledExecutionTime().getTime() + this.period);
        }
        return new Date(triggerContext.lastCompletionTime().getTime() + this.period);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + (this.fixedRate ? 1231 : 1237);
        result = 31 * result + (int)(this.initialDelay ^ this.initialDelay >>> 32);
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CountTrigger other = (CountTrigger)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.fixedRate != other.fixedRate) {
            return false;
        }
        if (this.initialDelay != other.initialDelay) {
            return false;
        }
        return this.period == other.period;
    }
}

