/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config.configurers;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.statemachine.config.builders.StateMachineConfigurationBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.statemachine.config.configurers.ConfigurationConfigurer;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.listener.StateMachineListener;

public class DefaultConfigurationConfigurer<S, E>
extends AnnotationConfigurerAdapter<ConfigurationData<S, E>, StateMachineConfigurationConfigurer<S, E>, StateMachineConfigurationBuilder<S, E>>
implements ConfigurationConfigurer<S, E> {
    private String machineId;
    private BeanFactory beanFactory;
    private TaskExecutor taskExecutor;
    private TaskScheduler taskScheculer;
    private boolean autoStart = false;
    private final List<StateMachineListener<S, E>> listeners = new ArrayList<StateMachineListener<S, E>>();

    @Override
    public void configure(StateMachineConfigurationBuilder<S, E> builder) throws Exception {
        builder.setMachineId(this.machineId);
        builder.setBeanFactory(this.beanFactory);
        builder.setTaskExecutor(this.taskExecutor);
        builder.setTaskScheculer(this.taskScheculer);
        builder.setAutoStart(this.autoStart);
        builder.setStateMachineListeners(this.listeners);
    }

    @Override
    public ConfigurationConfigurer<S, E> machineId(String id) {
        this.machineId = id;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> taskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> taskScheduler(TaskScheduler taskScheduler) {
        this.taskScheculer = taskScheduler;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> autoStartup(boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    @Override
    public ConfigurationConfigurer<S, E> listener(StateMachineListener<S, E> listener) {
        this.listeners.add(listener);
        return this;
    }
}

