/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.events;

import com.atlassian.analytics.api.annotations.EventName;
import java.util.Map;
import java.util.Objects;

@EventName(value="jira.optimizer.scan.finish")
public class ScanFinishedEvent {
    private final long duration;
    private final Map<String, Long> cfCount;
    private final Map<String, Integer> recommendationCount;
    private final Map<String, Map<String, Long>> impact;

    public ScanFinishedEvent(long duration, Map<String, Long> cfCount, Map<String, Integer> recommendationCount, Map<String, Map<String, Long>> impact) {
        this.duration = duration;
        this.cfCount = cfCount;
        this.recommendationCount = recommendationCount;
        this.impact = impact;
    }

    public long getDuration() {
        return this.duration;
    }

    public Map<String, Map<String, Long>> getImpact() {
        return this.impact;
    }

    public Map<String, Long> getCfCount() {
        return this.cfCount;
    }

    public Map<String, Integer> getRecommendationCount() {
        return this.recommendationCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanFinishedEvent that = (ScanFinishedEvent)o;
        return this.duration == that.duration && Objects.equals(this.cfCount, that.cfCount) && Objects.equals(this.recommendationCount, that.recommendationCount) && Objects.equals(this.impact, that.impact);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.cfCount, this.recommendationCount, this.impact);
    }
}

