/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.beans;

import com.atlassian.jira.optimizer.ao.RecommendationAO;
import com.atlassian.jira.optimizer.ao.RecommendationsDao;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonProperty;

public class RecommendationBean
implements Comparable<RecommendationBean> {
    private static final Comparator<RecommendationBean> COMPARATOR = Comparator.comparingDouble(RecommendationBean::getPerformanceImpact).reversed().thenComparing(RecommendationBean::getName);
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String category;
    @JsonProperty
    private String type;
    @JsonProperty
    private double performanceImpact;
    @JsonProperty
    boolean resolved;
    @JsonProperty
    Long customFieldId;
    @JsonProperty
    List<Long> projectIds;

    public RecommendationBean() {
    }

    public RecommendationBean(String id, String name, String category, Long customFieldId, List<Long> projectIds, String type, double performanceImpact) {
        this(id, name, category, customFieldId, projectIds, type, performanceImpact, false);
    }

    public RecommendationBean(RecommendationAO recommendationAO) {
        this(recommendationAO.getID(), recommendationAO.getName(), recommendationAO.getCategory(), recommendationAO.getCustomFieldId(), RecommendationsDao.parceProjectIdString(recommendationAO.getProjectIds()), recommendationAO.getType(), recommendationAO.getPerformanceImpact(), recommendationAO.isResolved());
    }

    public RecommendationBean(String id, String name, String category, Long customFieldId, List<Long> projectIds, String type, double performanceImpact, boolean resolved) {
        this.id = id;
        this.name = name;
        this.category = category;
        this.type = type;
        this.customFieldId = customFieldId;
        this.projectIds = projectIds;
        this.performanceImpact = performanceImpact;
        this.resolved = resolved;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public double getPerformanceImpact() {
        return this.performanceImpact;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public Long getCustomFieldId() {
        return this.customFieldId;
    }

    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    public String toString() {
        return "RecommendationBean{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", category='" + this.category + '\'' + ", customFieldId='" + this.customFieldId + '\'' + ", projectIds='" + this.projectIds + '\'' + ", type='" + this.type + '\'' + ", performanceImpact=" + this.performanceImpact + ", resolved='" + this.resolved + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecommendationBean that = (RecommendationBean)o;
        return this.performanceImpact == that.performanceImpact && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.category, that.category) && Objects.equals(this.customFieldId, that.customFieldId) && Objects.equals(this.projectIds, that.projectIds) && Objects.equals(this.type, that.type) && this.resolved == that.resolved;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.category, this.customFieldId, this.projectIds, this.type, this.performanceImpact, this.resolved);
    }

    @Override
    public int compareTo(RecommendationBean o) {
        return COMPARATOR.compare(this, o);
    }
}

