/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.ensemble;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.ensemble.CompositeEnsembleListener;
import org.springframework.statemachine.ensemble.EnsembleListener;
import org.springframework.statemachine.ensemble.StateMachineEnsemble;
import org.springframework.statemachine.ensemble.StateMachineEnsembleException;
import org.springframework.statemachine.support.LifecycleObjectSupport;

public abstract class StateMachineEnsembleObjectSupport<S, E>
extends LifecycleObjectSupport
implements StateMachineEnsemble<S, E> {
    private static final Log log = LogFactory.getLog(StateMachineEnsembleObjectSupport.class);
    private final CompositeEnsembleListener<S, E> ensembleListener = new CompositeEnsembleListener();

    @Override
    public abstract void join(StateMachine<S, E> var1);

    @Override
    public abstract void leave(StateMachine<S, E> var1);

    @Override
    public void addEnsembleListener(EnsembleListener<S, E> listener) {
        this.ensembleListener.register(listener);
    }

    @Override
    public void removeEnsembleListener(EnsembleListener<S, E> listener) {
        this.ensembleListener.unregister(listener);
    }

    protected void notifyJoined(StateMachine<S, E> stateMachine, StateMachineContext<S, E> context) {
        this.ensembleListener.stateMachineJoined(stateMachine, context);
    }

    protected void notifyLeft(StateMachine<S, E> stateMachine, StateMachineContext<S, E> context) {
        this.ensembleListener.stateMachineLeft(stateMachine, context);
    }

    protected void notifyError(StateMachineEnsembleException exception) {
        this.ensembleListener.ensembleError(exception);
    }

    protected void notifyGranted(StateMachine<S, E> stateMachine) {
        this.ensembleListener.ensembleLeaderGranted(stateMachine);
    }

    protected void notifyRevoked(StateMachine<S, E> stateMachine) {
        this.ensembleListener.ensembleLeaderRevoked(stateMachine);
    }

    protected void notifyStateChanged(StateMachineContext<S, E> context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Notify notifyStateChanged " + context));
        }
        this.ensembleListener.stateChanged(context);
    }
}

