/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.config;

import org.springframework.statemachine.config.StateMachineConfig;
import org.springframework.statemachine.config.builders.StateMachineConfigBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationBuilder;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.builders.StateMachineConfigurer;
import org.springframework.statemachine.config.builders.StateMachineModelBuilder;
import org.springframework.statemachine.config.builders.StateMachineModelConfigurer;
import org.springframework.statemachine.config.builders.StateMachineStateBuilder;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionBuilder;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.common.annotation.AnnotationBuilder;
import org.springframework.statemachine.config.common.annotation.ObjectPostProcessor;

public abstract class AbstractStateMachineConfigurerAdapter<S, E>
implements StateMachineConfigurer<S, E> {
    private StateMachineModelBuilder<S, E> modelBuilder;
    private StateMachineTransitionBuilder<S, E> transitionBuilder;
    private StateMachineStateBuilder<S, E> stateBuilder;
    private StateMachineConfigurationBuilder<S, E> configurationBuilder;

    @Override
    public final void init(StateMachineConfigBuilder<S, E> config) throws Exception {
        config.setSharedObject(StateMachineModelBuilder.class, this.getStateMachineModelBuilder());
        config.setSharedObject(StateMachineTransitionBuilder.class, this.getStateMachineTransitionBuilder());
        config.setSharedObject(StateMachineStateBuilder.class, this.getStateMachineStateBuilder());
        config.setSharedObject(StateMachineConfigurationBuilder.class, this.getStateMachineConfigurationBuilder());
    }

    @Override
    public void configure(StateMachineConfigBuilder<S, E> config) throws Exception {
    }

    @Override
    public void configure(StateMachineModelConfigurer<S, E> model) throws Exception {
    }

    @Override
    public void configure(StateMachineConfigurationConfigurer<S, E> config) throws Exception {
    }

    @Override
    public void configure(StateMachineStateConfigurer<S, E> states) throws Exception {
    }

    @Override
    public void configure(StateMachineTransitionConfigurer<S, E> transitions) throws Exception {
    }

    @Override
    public boolean isAssignable(AnnotationBuilder<StateMachineConfig<S, E>> builder) {
        return builder instanceof StateMachineConfigBuilder;
    }

    protected final StateMachineModelBuilder<S, E> getStateMachineModelBuilder() throws Exception {
        if (this.modelBuilder != null) {
            return this.modelBuilder;
        }
        this.modelBuilder = new StateMachineModelBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
        this.configure(this.modelBuilder);
        return this.modelBuilder;
    }

    protected final StateMachineTransitionBuilder<S, E> getStateMachineTransitionBuilder() throws Exception {
        if (this.transitionBuilder != null) {
            return this.transitionBuilder;
        }
        this.transitionBuilder = new StateMachineTransitionBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
        this.configure(this.transitionBuilder);
        return this.transitionBuilder;
    }

    protected final StateMachineStateBuilder<S, E> getStateMachineStateBuilder() throws Exception {
        if (this.stateBuilder != null) {
            return this.stateBuilder;
        }
        this.stateBuilder = new StateMachineStateBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
        this.configure(this.stateBuilder);
        return this.stateBuilder;
    }

    protected final StateMachineConfigurationBuilder<S, E> getStateMachineConfigurationBuilder() throws Exception {
        if (this.configurationBuilder != null) {
            return this.configurationBuilder;
        }
        this.configurationBuilder = new StateMachineConfigurationBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR, true);
        this.configure(this.configurationBuilder);
        return this.configurationBuilder;
    }
}

