/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.optimizer.ao.RecommendationAO;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.java.ao.DBParam;
import org.springframework.stereotype.Component;

@Component
public class RecommendationsDao {
    private final ActiveObjects activeObjects;

    @Inject
    public RecommendationsDao(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void removeAll() {
        this.activeObjects.deleteWithSQL(RecommendationAO.class, null, new Object[0]);
        this.activeObjects.flushAll();
    }

    public RecommendationAO[] getAllRecommendations() {
        return (RecommendationAO[])this.activeObjects.find(RecommendationAO.class);
    }

    public RecommendationAO[] getByCategory(String category) {
        return (RecommendationAO[])this.activeObjects.find(RecommendationAO.class, "category = ?", new Object[]{category});
    }

    public RecommendationAO getById(String id) {
        return (RecommendationAO)this.activeObjects.get(RecommendationAO.class, (Object)id);
    }

    public void setResolved(String id, Boolean resolved) {
        RecommendationAO recommendationAO = (RecommendationAO)this.activeObjects.get(RecommendationAO.class, (Object)id);
        recommendationAO.setResolved(resolved);
        recommendationAO.save();
    }

    public void createRecommendation(String id, String name, String category, Long customFieldId, String type, double performanceImpact, List<Long> projectIds) {
        String projectString = projectIds.stream().map(Object::toString).collect(Collectors.joining(","));
        this.activeObjects.create(RecommendationAO.class, new DBParam[]{new DBParam("ID", (Object)id), new DBParam("NAME", (Object)name), new DBParam("CATEGORY", (Object)category), new DBParam("TYPE", (Object)type), new DBParam("PERFORMANCE_IMPACT", (Object)performanceImpact), new DBParam("RESOLVED", (Object)false), new DBParam("CUSTOM_FIELD_ID", (Object)customFieldId), new DBParam("PROJECT_IDS", (Object)projectString)});
    }

    public static List<Long> parceProjectIdString(String projectIdString) {
        return "".equals(projectIdString) ? Collections.emptyList() : Stream.of(projectIdString.split(",")).map(Long::parseLong).collect(Collectors.toList());
    }
}

