/**
 * This view renders details of a recommendation (Type, Description etc)
 */
define('jira/optimizer-plugin/recommendationView', ['jira-optimizer-plugin/marionette-2.1.0', 'jira/flag', 'wrm/context-path', 'jquery', 'jira/optimizer-plugin/confirmationView'], function (Marionette, Flag, contextPath, $, ConfirmationView) {
    'use strict';

    return Marionette.ItemView.extend({
        template: CustomfieldAnalyzer.Templates.Recommendation,
        tagName: 'tr',
        attributes: function attributes() {
            return {
                "data-custom-field-id": this.model.get("customFieldId"),
                "data-id": this.model.get("id")
            };
        },
        ui: {
            actionButton: '.jgp-action-button',
            viewChangeButton: '.jgp-view-change-button'
        },
        events: {
            'click @ui.actionButton': 'handleChangeContext'
        },
        handleChangeContext: function handleChangeContext() {
            this.confirmationView = new ConfirmationView({ model: this.model });
            this.listenTo(this.confirmationView, 'confirm', this.performAutomaticResolution);
        },
        performAutomaticResolution: function performAutomaticResolution() {
            var _this = this;

            /* Sends a PUT request to /rest/optimizer/1/recommendation/{model id}
               for example rest/optimizer/1/recommendation/customfield_10003
             */
            return $.ajax({
                url: this.model.url(),
                type: 'PUT'
            }).done(function () {
                _this.model.set("resolved", true);
                _this.render();
                Flag.showSuccessMsg('', AJS.I18n.getText('optimizer.plugin.field.optimised', _this.model.get("name")));
            }).fail(function (response) {
                _this.showRefreshFlag(response.responseText);
            }).always(function () {
                return _this.confirmationView.destroy();
            });
        },
        showRefreshFlag: function showRefreshFlag(message) {
            var flag = Flag.showErrorMsg(AJS.I18n.getText('optimizer.plugin.refresh.page'), message + '\n                        <ul class="aui-nav-actions-list">\n                            <li><a class="aui-button aui-button-link" href="#">Refresh</a></li>\n                        </ul>');
            $(flag).on("click", ".aui-button-link", function (e) {
                e.preventDefault();
                window.location.reload();
            });
        },
        destroy: function destroy() {
            if (this.confirmationView) {
                this.confirmationView.destroy();
            }
            Marionette.ItemView.prototype.destroy.call(this);
        }
    });
});