/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.optimizer.impl;

import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldsBlackList {
    private final Set<BlackListEntry> blacklistedCustomFields = ImmutableSet.of((Object)new BlackListEntry("com.atlassian.jira.plugins.jira-development-integration-plugin:devsummary", "Development"), (Object)new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", "Flagged"), (Object)new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:float", "Business Value"), (Object)new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:labels", "Epic/Theme"), (Object)new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:float", "Story Points"), (Object)new BlackListEntry("com.atlassian.servicedesk:sd-request-feedback", "Satisfaction"), (Object[])new BlackListEntry[]{new BlackListEntry("com.atlassian.servicedesk:sd-request-feedback-date", "Satisfaction date"), new BlackListEntry("com.atlassian.servicedesk:sd-customer-organizations", "Organizations"), new BlackListEntry("com.atlassian.servicedesk:vp-origin", "Customer Request Type"), new BlackListEntry("com.atlassian.servicedesk:sd-request-participants", "Request participants"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", "Approvers"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", "CAB"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:datetime", "Change completion date"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", "Change managers"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Change reason"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Change risk"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:datetime", "Change start date"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Change type"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Impact"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Investigation reason"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", "Operational categorization"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Pending reason"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", "Product categorization"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Source"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:select", "Urgency"), new BlackListEntry("com.atlassian.jira.plugin.system.customfieldtypes:textarea", "Workaround"), new BlackListEntry("com.atlassian.servicedesk.approvals-plugin", "Approvals")});

    public boolean isTreatedAsSystem(CustomField customField) {
        return this.blacklistedCustomFields.contains(new BlackListEntry(customField));
    }

    private static class BlackListEntry {
        private final String customFieldTypeKey;
        private final String customFieldName;

        BlackListEntry(String customFieldTypeKey, String customFieldName) {
            this.customFieldTypeKey = Objects.requireNonNull(customFieldTypeKey);
            this.customFieldName = Objects.requireNonNull(customFieldName);
        }

        BlackListEntry(CustomField customField) {
            this(customField.getCustomFieldType().getKey(), customField.getUntranslatedName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlackListEntry that = (BlackListEntry)o;
            return Objects.equals(this.customFieldTypeKey, that.customFieldTypeKey) && Objects.equals(this.customFieldName, that.customFieldName);
        }

        public int hashCode() {
            return Objects.hash(this.customFieldTypeKey, this.customFieldName);
        }
    }
}

