AJS.test.require(["com.atlassian.jira.plugins.jira-importers-github-plugin:webResources"], function () {
    require(["jquery"], function ($) {
        // All the code should be agnostic to the actual value, so we'll test using a random value, but really any string
        // should do here.
        var externalSystem = "OUN!)D*)l;ldka8c2uº…£";

        /**
         * Create an object that matches the /fetchData/…/progress REST API shape.
         * @param {object} [options={}] values to override.
         */
        function mockProgress(options) {
            options = options || {};

            return $.extend({
                error: "97f9Q#&H(udnkqlmadw…ºº",
                warning: "LAOKF_(!KPO:A:",
                currentClosedIssue: 1,
                totalClosedIssues: 1,
                currentOpenIssue: 1,
                totalOpenIssues: 1,
                currentProject: 1,
                totalProjects: 1,
                finished: false
            }, options);
        }

        /**
         * Quote regular expression special characters so that it may be safely used as a literal in a regular expression.
         * @param {string} str
         * @returns {string}
         */
        function regexQuote(str) {
            return (str+'').replace(/[.?*+^$[\]\\(){}|-]/g, "\\$&");
        }

        module("fetchData", {
            setup: function () {
                this.context = AJS.test.mockableModuleContext();
                this.domSandbox = $("#qunit-fixture");

                // All tests should be agnostic to the actual _value_ of contextPath, so it's reasonable to mock it.
                this.contextPath = "L:)(_A—mfaowuf082";
                this.context.mock("jira-github-importer/lib/contextPath", this.contextPath);

                this.server = sinon.fakeServer.create();
            },

            tearDown: function () {
                this.server.restore();
            }
        });

        test(".cancel() makes POST HTTP request to cancel the fetch for the specified external system and then redirects to the mapping page", function () {
            var window = {document: {location: {}}};
            var fetchData = this.context
                .mock("jira-github-importer/lib/window", window)
                .require("jira-github-importer/fetchData");

            this.server.respondWith("POST",
                this.contextPath + "/rest/github-importer-plugin/1.0/fetchData/" + externalSystem + "/cancel",
                [200, {}, '']);

            fetchData.cancel(externalSystem);
            this.server.respond();

            equal(window.document.location.href, this.contextPath + "/GithubProjectMappingPage!default.jspa?externalSystem=" + externalSystem);
        });

        test(".cancel() disables the cancel button immediately", function () {
            var cancelButton = $('<div id="cancelBtn"></div>');
            this.domSandbox.append(cancelButton);
            var externalSystem = "github";
            var fetchData = this.context.require("jira-github-importer/fetchData");

            fetchData.cancel(externalSystem);

            equal(cancelButton.attr("disabled"), "disabled");
        });

        test(".pollProgress() checks progress via AJAX and redirects if finished", function () {
            var window = {document: {location: {}}};
            var fetchData = this.context
                .mock("jira-github-importer/lib/window", window)
                .require("jira-github-importer/fetchData");

            this.server.respondWith("GET",
                new RegExp(regexQuote(this.contextPath + "/rest/github-importer-plugin/1.0/fetchData/" + externalSystem + "/progress?_=") + ".+"),
                [200, {"Content-Type": "application/json"}, JSON.stringify(mockProgress({finished: true}))]);

            fetchData.pollProgress(externalSystem);
            this.server.respond();

            equal(window.document.location.href, this.contextPath + "/secure/admin/GithubLabelMappingPage!default.jspa?externalSystem=" + externalSystem);
        });

        test(".pollProgress() checks progress via AJAX and schedules another poll later if the not import has not finished", function () {
            var window = {setTimeout: sinon.stub()};
            var fetchData = this.context
                .mock("jira-github-importer/lib/window", window)
                .require("jira-github-importer/fetchData");

            this.server.respondWith("GET",
                new RegExp(regexQuote(this.contextPath + "/rest/github-importer-plugin/1.0/fetchData/" + externalSystem + "/progress?_=") + ".+"),
                [200, {"Content-Type": "application/json"}, JSON.stringify(mockProgress({finished: false}))]);
            fetchData.pollProgress(externalSystem);
            this.server.respond();

            var nextPoll = window.setTimeout.firstCall.args[0];
            var nextPollDelay = window.setTimeout.firstCall.args[1];

            // The first subsequent call should be 500ms after the first.
            equal(nextPollDelay, 500);

            fetchData.pollProgress = sinon.stub();
            nextPoll();

            // pollProgress should be called with the same externalSystem value, and a backed-off pollDelay.
            deepEqual(fetchData.pollProgress.args, [[externalSystem, 1.2 * 500]]);
        });

        test(".pollProgress() checks progress via AJAX and schedules another poll after 2 seconds if the request failed", function () {
            var window = {setTimeout: sinon.stub()};
            var fetchData = this.context
                .mock("jira-github-importer/lib/window", window)
                .require("jira-github-importer/fetchData");

            fetchData.pollProgress(externalSystem);
            this.server.respond();

            var nextPoll = window.setTimeout.firstCall.args[0];
            var nextPollDelay = window.setTimeout.firstCall.args[1];

            // The retry should be after 2000ms.
            equal(nextPollDelay, 2000);

            fetchData.pollProgress = sinon.stub();
            nextPoll();

            // pollProgress should be called with the same externalSystem value, and leave the pollDelay to the default
            deepEqual(fetchData.pollProgress.args, [[externalSystem]]);
        });
    });
});
