/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.importer.Attachment;
import com.atlassian.jira.plugins.importer.github.importer.markup.ConversionResult;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egit.github.core.Repository;

public class AttachmentsConverter {
    private final ConfigBean configBean;

    public AttachmentsConverter(ConfigBean configBean) {
        this.configBean = configBean;
    }

    public ConversionResult convert(Repository repository, String content) {
        HashSet attachments = Sets.newHashSet();
        Pattern pattern = Pattern.compile("(!?)\\[(.*?)\\]\\((.*?)(\\s+\\\".*?\\\")?\\)");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            boolean importAttachment;
            String entireMatch = matcher.group();
            boolean isEmbeddedContent = matcher.group(1).equals("!");
            String linkId = matcher.group(2);
            String linkTarget = matcher.group(3);
            if (isEmbeddedContent) {
                int beginIndex = linkTarget.lastIndexOf(".");
                String fileType = beginIndex > 0 ? linkTarget.substring(beginIndex) : "";
                linkId = linkId + fileType;
            }
            boolean bl = importAttachment = this.isGithubAttachment(linkTarget) && isEmbeddedContent;
            if (importAttachment) {
                attachments.add(new Attachment(linkId, linkTarget));
            }
            String replacement = isEmbeddedContent ? (importAttachment ? "!" + linkId + "|thumbnail!" : "!" + linkTarget + "!") : this.formatNonImageLink(linkId, linkTarget, repository);
            content = content.replace(entireMatch, replacement);
        }
        return new ConversionResult(attachments, content);
    }

    private String formatNonImageLink(String linkId, String linkTarget, Repository repository) {
        if (linkTarget.startsWith(".")) {
            while (linkTarget.startsWith(".")) {
                linkTarget = linkTarget.replaceFirst("\\.", "");
            }
            return String.format("[%s|%s%s]", linkId, repository.getHtmlUrl(), linkTarget);
        }
        return String.format("[%s|%s]", linkId, linkTarget);
    }

    private boolean isGithubAttachment(String linkTarget) {
        if (this.configBean.isGithubEnterprise()) {
            return linkTarget.contains(this.configBean.getGithubUrl() + "/github-enterprise-assets");
        }
        return linkTarget.contains("://f.cloud.github.com/assets");
    }
}

