/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.fetch;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.github.fetch.FetchProgress;
import com.atlassian.jira.plugins.importer.github.fetch.GithubDataService;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.eclipse.egit.github.core.client.RequestException;

@ThreadSafe
public class DataFetchJob {
    private final Logger log = Logger.getLogger(this.getClass());
    private final GithubDataService githubDataService;
    private final AtomicReference<FutureTask<Void>> futureTaskAtomicReference = new AtomicReference();
    private final I18nHelper i18n;
    private FetchProgress fetchProgress;

    public DataFetchJob(GithubDataService githubDataService) {
        this.githubDataService = githubDataService;
        this.i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    public void run(List<String> selectedProjects) {
        this.fetchProgress = new FetchProgress();
        FutureTask<Void> future = new FutureTask<Void>(new DataFetchCallable(selectedProjects, this.fetchProgress));
        if (this.futureTaskAtomicReference.compareAndSet(null, future)) {
            try {
                this.log.info((Object)"Starting data fetch job");
                future.run();
            }
            finally {
                this.log.info((Object)"Data fetch job has stopped");
                this.futureTaskAtomicReference.set(null);
            }
        } else {
            throw new IllegalStateException("Fetch job is already running");
        }
    }

    public void cancel() {
        FutureTask<Void> future = this.futureTaskAtomicReference.get();
        if (future != null) {
            this.log.info((Object)"Cancelling data fetch job");
            future.cancel(true);
        }
        this.fetchProgress = new FetchProgress();
    }

    public boolean isRunning() {
        return this.futureTaskAtomicReference.get() != null;
    }

    public FetchProgress getFetchProgress() {
        return this.fetchProgress;
    }

    private class DataFetchCallable
    implements Callable<Void> {
        private final List<String> selectedProjects;
        private final FetchProgress fetchProgress;

        private DataFetchCallable(List<String> selectedProjects, FetchProgress fetchProgress) {
            this.selectedProjects = selectedProjects;
            this.fetchProgress = fetchProgress;
        }

        @Override
        public Void call() throws Exception {
            try {
                DataFetchJob.this.githubDataService.clearLoadedProjectData();
                this.fetchProgress.setTotalProjects(this.selectedProjects.size());
                int currentProjectNo = 1;
                for (String projectName : this.selectedProjects) {
                    DataFetchJob.this.githubDataService.loadProject(projectName, this.fetchProgress);
                    this.fetchProgress.setCurrentProject(currentProjectNo++);
                }
                this.fetchProgress.setFinished(true);
            }
            catch (InterruptedException e) {
                DataFetchJob.this.githubDataService.clearLoadedProjectData();
                throw e;
            }
            catch (Exception e) {
                if (e instanceof RequestException && ((RequestException)((Object)e)).getStatus() == 410) {
                    this.fetchProgress.setError(DataFetchJob.this.i18n.getText("com.atlassian.jira.plugins.importer.github.fetchData.error.issuesDisabled"));
                    DataFetchJob.this.log.warn((Object)"Fetching data from GitHub failed", (Throwable)e);
                }
                this.fetchProgress.setError(DataFetchJob.this.i18n.getText("com.atlassian.jira.plugins.importer.github.fetchData.error.otherExceptions"));
                DataFetchJob.this.log.error((Object)"Fetching data from GitHub failed", (Throwable)e);
            }
            return null;
        }
    }
}

