/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.web;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.plugins.importer.github.GithubImportProcessBean;
import com.atlassian.jira.plugins.importer.github.fetch.auth.GithubAuthenticator;
import com.atlassian.jira.plugins.importer.github.web.GithubImportProcessSupport;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;

public class GithubAuthenticationPage
extends GithubImportProcessSupport {
    private String authCode;

    public GithubAuthenticationPage(@ComponentImport UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor, projectManager, issueTypeSchemeManager, workflowSchemeManager);
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public boolean is2FARequired() {
        GithubImportProcessBean processBean = this.getProcessBean();
        return processBean != null && processBean.getAuthenticator().isTwoFactorAuthenticationEnabled();
    }

    public String doDefault() throws Exception {
        if (!this.isAdministrator()) {
            return "denied";
        }
        if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
            return "restartimporterneeded";
        }
        return "input";
    }

    protected void doValidation() {
        super.doValidation();
        if (this.isPreviousClicked()) {
            return;
        }
        if (!this.isNextClicked()) {
            return;
        }
        GithubImportProcessBean processBean = this.getProcessBean();
        if (processBean == null) {
            return;
        }
        GithubAuthenticator authenticator = processBean.getAuthenticator();
        if (authenticator.isTwoFactorAuthenticationEnabled()) {
            GithubAuthenticator.AuthorizationResponse authorizationResponse = authenticator.tryAuthenticateWith2FAToken(this.authCode);
            if (authorizationResponse.getState() != GithubAuthenticator.AuthState.OK) {
                this.addErrorMessage(this.getText("com.atlassian.jira.plugins.importer.github.error.invalid.auth.code"));
            } else {
                processBean.getGithubDataService().setGitHubClient(authenticator.buildAuthenticatedClient());
            }
        }
    }

    public String getFormTitle() {
        return this.getText("com.atlassian.jira.plugins.importer.github.oauth.title");
    }
}

