/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.rest.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.extensions.ExternalSystemImporterModuleDescriptor;
import com.atlassian.jira.plugins.importer.github.GithubImporterController;
import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.config.SchemeStatusMapping;
import com.atlassian.jira.plugins.importer.github.rest.workflow.SchemeWorkflow;
import com.atlassian.jira.plugins.importer.github.rest.workflow.WorkflowService;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="workflow")
public class WorkflowResource {
    private final Logger log = Logger.getLogger(this.getClass());
    public static final String DEFAULT_WORKFLOW_SCHEME_KEY = "[DEFAULT-WORKFLOW-SCHEME]";
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final PluginAccessor pluginAccessor;
    private final ConstantsManager constantsManager;
    private final WorkflowService workflowService;

    public WorkflowResource(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport WorkflowManager workflowManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport ConstantsManager constantsManager) {
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.pluginAccessor = pluginAccessor;
        this.constantsManager = constantsManager;
        this.workflowService = new WorkflowService(workflowManager, workflowSchemeManager, constantsManager);
    }

    @GET
    @Path(value="/scheme")
    @Produces(value={"application/json"})
    public Response getSchemeWorkflows(@QueryParam(value="name") String workflowSchemeName) {
        if (!this.isAdministrator()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.log.debug((Object)("Retrieving states of workflow scheme " + workflowSchemeName));
        if (DEFAULT_WORKFLOW_SCHEME_KEY.equals(workflowSchemeName)) {
            workflowSchemeName = null;
        }
        HashMap<String, SchemeWorkflow> workflowToSchemeWorkflowMap = new HashMap<String, SchemeWorkflow>();
        for (IssueType issueType : this.constantsManager.getAllIssueTypeObjects()) {
            JiraWorkflow workflow = this.workflowService.getWorkflow(workflowSchemeName, issueType.getId());
            SchemeWorkflow schemeWorkflow = (SchemeWorkflow)workflowToSchemeWorkflowMap.get(workflow.getName());
            if (schemeWorkflow == null) {
                schemeWorkflow = new SchemeWorkflow(workflow.getName(), workflow.getDescription());
                workflowToSchemeWorkflowMap.put(workflow.getName(), schemeWorkflow);
            }
            schemeWorkflow.getAssociatedTypes().add(new SchemeWorkflow.JiraIssueType(issueType.getId(), issueType.getName(), issueType.getIconUrl()));
            List statuses = Lists.transform((List)workflow.getLinkedStatusObjects(), (Function)new Function<Status, SchemeWorkflow.JiraIssueStatus>(){

                public SchemeWorkflow.JiraIssueStatus apply(@Nullable Status input) {
                    return new SchemeWorkflow.JiraIssueStatus(input.getId(), input.getName());
                }
            });
            schemeWorkflow.setStatuses(statuses);
        }
        String json = this.toJSON(workflowToSchemeWorkflowMap.values());
        return Response.ok((Object)json).build();
    }

    @GET
    @Path(value="/schemeMapping")
    @Produces(value={"application/json"})
    public Response getSchemeWorkflowMapping(@Context HttpServletRequest req) {
        Optional<ConfigBean> configBean = this.getConfigBean(req);
        if (!configBean.isPresent() || ((ConfigBean)((Object)configBean.get())).getSchemeStatusMapping() == null) {
            return Response.noContent().build();
        }
        SchemeStatusMapping schemeStatusMapping = ((ConfigBean)((Object)configBean.get())).getSchemeStatusMapping();
        return Response.ok((Object)this.toJSON(schemeStatusMapping.getWorkflowIdToStatusMapping())).build();
    }

    private Optional<ConfigBean> getConfigBean(HttpServletRequest req) {
        AbstractConfigBean abstractConfigBean;
        ImportProcessBean importProcessBean = this.getController().getImportProcessBean(req.getSession(false));
        AbstractConfigBean abstractConfigBean2 = abstractConfigBean = importProcessBean != null ? importProcessBean.getConfigBean() : null;
        if (abstractConfigBean instanceof ConfigBean) {
            return Optional.of((Object)((Object)((ConfigBean)abstractConfigBean)));
        }
        return Optional.absent();
    }

    private GithubImporterController getController() {
        ExternalSystemImporterModuleDescriptor moduleDescriptor = (ExternalSystemImporterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("com.atlassian.jira.plugins.jira-importers-github-plugin:githubImporterKey");
        if (moduleDescriptor == null) {
            throw new RuntimeException("No active ImporterController found");
        }
        return (GithubImporterController)((Object)moduleDescriptor.getModule());
    }

    protected boolean isAdministrator() {
        User currentUser = this.authenticationContext.getLoggedInUser();
        return currentUser != null && this.globalPermissionManager.hasPermission(0, currentUser);
    }

    private String toJSON(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

