/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.github.fetch;

import com.atlassian.jira.plugins.importer.github.fetch.FetchProgress;
import com.atlassian.jira.plugins.importer.github.fetch.Project;
import com.atlassian.jira.plugins.importer.github.fetch.RemoteCall;
import com.atlassian.jira.plugins.importer.github.fetch.StarredRepositoryService;
import com.atlassian.jira.plugins.importer.github.util.GithubRequestService;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.egit.github.core.service.MilestoneService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.github.core.service.UserService;

public class GithubDataService {
    private final Logger log = Logger.getLogger(this.getClass());
    private GitHubClient gitHubClient;
    private List<Repository> repositories;
    private final Map<String, Project> projects = new HashMap<String, Project>();
    private final List<Issue> allIssues = new ArrayList<Issue>();
    private final Set<Label> allLabels = new HashSet<Label>();
    private final Map<Issue, List<Comment>> issueComments = new HashMap<Issue, List<Comment>>();
    private final Cache<String, User> userCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, User>(){

        public User load(String key) throws Exception {
            UserService userService = new UserService(GithubDataService.this.gitHubClient);
            return userService.getUser(key);
        }
    });

    private void loadRepositories() throws IOException {
        if (this.repositories != null) {
            return;
        }
        if (this.gitHubClient == null) {
            throw new IllegalStateException("accessToken has not been set");
        }
        this.log.debug((Object)"Loading repositories");
        GitHubClient client = this.getGitHubClient();
        RepositoryService service = new RepositoryService(client);
        List allVisibleRepositories = service.getRepositories();
        final ImmutableMap repositoryMap = Maps.uniqueIndex((Iterable)allVisibleRepositories, (Function)new Function<Repository, Long>(){

            public Long apply(Repository input) {
                return input.getId();
            }
        });
        StarredRepositoryService starredRepositoryService = new StarredRepositoryService(client);
        List<Repository> starredRepositories = starredRepositoryService.getStarredRepositories();
        Iterable filteredStarredRepos = Iterables.filter(starredRepositories, (Predicate)new Predicate<Repository>(){

            public boolean apply(Repository input) {
                return !repositoryMap.containsKey((Object)input.getId());
            }
        });
        allVisibleRepositories.addAll(Lists.newArrayList((Iterable)filteredStarredRepos));
        final LabelService labelService = new LabelService(this.gitHubClient);
        Iterable accessibleRepos = Iterables.filter((Iterable)allVisibleRepositories, (Predicate)new Predicate<Repository>(){

            public boolean apply(@Nullable Repository input) {
                try {
                    labelService.getLabels((IRepositoryIdProvider)input);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
        this.repositories = ImmutableList.copyOf((Iterable)accessibleRepos);
    }

    public Optional<User> getUserWithDetails(String login) {
        try {
            return Optional.of((Object)this.userCache.get((Object)login));
        }
        catch (ExecutionException e) {
            return Optional.absent();
        }
    }

    public List<String> getAllProjectNames() throws IOException {
        this.loadRepositories();
        return Lists.transform(this.repositories, (Function)new Function<Repository, String>(){

            public String apply(@Nullable Repository input) {
                return input.generateId();
            }
        });
    }

    public void clearLoadedProjectData() {
        this.projects.clear();
        this.allIssues.clear();
        this.allLabels.clear();
        this.issueComments.clear();
    }

    public void loadProject(String projectName, final FetchProgress fetchProgress) throws IOException, InterruptedException {
        if (this.projects.containsKey(projectName)) {
            throw new IllegalStateException("Project '" + projectName + "' already loaded");
        }
        this.log.debug((Object)("Loading project " + projectName));
        Repository repository = this.getRepository(projectName);
        GithubRequestService requestService = new GithubRequestService(new GithubRequestService.FailureCallback(){

            @Override
            public void retry(String msg) {
                fetchProgress.setWarning(msg);
            }

            @Override
            public void retriesFinished() {
                fetchProgress.setWarning(null);
            }
        });
        this.loadAndAddRepositoryLabels(repository, requestService);
        List<Milestone> milestones = this.loadMilestones(repository, requestService);
        HashMap<String, String> filterData = new HashMap<String, String>();
        filterData.put("state", "closed");
        List<Issue> projectIssues = this.loadProjectIssues(repository, filterData, new InternalProgressFeedback(){

            @Override
            public void onProgress(int currentIssue, Integer totalIssues) {
                fetchProgress.setCurrentClosedIssue(currentIssue);
                fetchProgress.setTotalClosedIssues(totalIssues);
            }
        }, requestService);
        filterData.put("state", "open");
        projectIssues.addAll(this.loadProjectIssues(repository, filterData, new InternalProgressFeedback(){

            @Override
            public void onProgress(int currentIssue, Integer totalIssues) {
                fetchProgress.setCurrentOpenIssue(currentIssue);
                fetchProgress.setTotalOpenIssues(totalIssues);
            }
        }, requestService));
        Collections.sort(projectIssues, new Comparator<Issue>(){

            @Override
            public int compare(Issue i1, Issue i2) {
                return i1.getNumber() - i2.getNumber();
            }
        });
        this.projects.put(projectName, new Project(repository, projectIssues, milestones));
        this.allIssues.addAll(projectIssues);
    }

    private void loadAndAddRepositoryLabels(final Repository repository, GithubRequestService requestService) throws IOException, InterruptedException {
        GitHubClient client = this.getGitHubClient();
        final LabelService labelService = new LabelService(client);
        List<Label> issueLabels = requestService.submit(new RemoteCall<List<Label>>(){

            @Override
            public List<Label> call() throws IOException {
                return labelService.getLabels((IRepositoryIdProvider)repository);
            }
        });
        this.allLabels.addAll(issueLabels);
    }

    private List<Milestone> loadMilestones(final Repository repository, GithubRequestService requestService) throws IOException, InterruptedException {
        final MilestoneService milestoneService = new MilestoneService(this.getGitHubClient());
        List<Milestone> closedMilestones = requestService.submit(new RemoteCall<List<Milestone>>(){

            @Override
            public List<Milestone> call() throws IOException {
                return milestoneService.getMilestones((IRepositoryIdProvider)repository, "closed");
            }
        });
        List<Milestone> openMilestones = requestService.submit(new RemoteCall<List<Milestone>>(){

            @Override
            public List<Milestone> call() throws IOException {
                return milestoneService.getMilestones((IRepositoryIdProvider)repository, "open");
            }
        });
        return new ImmutableList.Builder().addAll(closedMilestones).addAll(openMilestones).build();
    }

    private List<Issue> loadProjectIssues(final Repository repository, final Map<String, String> filterData, InternalProgressFeedback progress, GithubRequestService requestService) throws IOException, InterruptedException {
        GitHubClient client = this.getGitHubClient();
        final IssueService issueService = new IssueService(client);
        ArrayList<Issue> projectIssues = new ArrayList<Issue>();
        int currentIssue = 0;
        Integer totalIssues = null;
        final PageIterator<Issue> pager = requestService.submit(new RemoteCall<PageIterator<Issue>>(){

            @Override
            public PageIterator<Issue> call() throws IOException {
                return issueService.pageIssues((IRepositoryIdProvider)repository, filterData);
            }
        });
        while (pager.hasNext()) {
            Collection<Issue> pageIssues = requestService.submit(new RemoteCall<Collection<Issue>>(){

                @Override
                public Collection<Issue> call() throws IOException {
                    return pager.next();
                }
            });
            projectIssues.addAll(pageIssues);
            if (totalIssues == null) {
                totalIssues = pager.getLastPage() != -1 ? Integer.valueOf(pager.getLastPage() * pageIssues.size()) : Integer.valueOf(pageIssues.size());
            }
            for (final Issue issue : pageIssues) {
                List<Comment> comments = requestService.submit(new RemoteCall<List<Comment>>(){

                    @Override
                    public List<Comment> call() throws IOException {
                        return issueService.getComments((IRepositoryIdProvider)repository, String.valueOf(issue.getNumber()));
                    }
                });
                this.issueComments.put(issue, comments);
                progress.onProgress(++currentIssue, totalIssues);
            }
        }
        totalIssues = totalIssues == null ? Integer.valueOf(0) : Integer.valueOf(currentIssue);
        progress.onProgress(currentIssue, totalIssues);
        return projectIssues;
    }

    private void ensureDataIsLoaded() {
        if (!this.hasDataBeenLoaded()) {
            throw new IllegalStateException("Data has not been loaded yet");
        }
    }

    public boolean hasDataBeenLoaded() {
        return !this.projects.isEmpty();
    }

    public List<Project> getProjects() {
        this.ensureDataIsLoaded();
        return Lists.newArrayList(this.projects.values());
    }

    public Project getProjectByName(String projectName) {
        this.ensureDataIsLoaded();
        return this.projects.get(projectName);
    }

    public List<Issue> getAllIssues() {
        this.ensureDataIsLoaded();
        return this.allIssues;
    }

    public List<Label> getLabels() {
        this.ensureDataIsLoaded();
        ArrayList<Label> labels = new ArrayList<Label>(this.allLabels);
        Collections.sort(labels, new Comparator<Label>(){

            @Override
            public int compare(Label o1, Label o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return labels;
    }

    public List<Comment> getComments(Issue issue) {
        this.ensureDataIsLoaded();
        return this.issueComments.get(issue);
    }

    public void setGitHubClient(GitHubClient gitHubClient) {
        this.gitHubClient = gitHubClient;
    }

    private Repository getRepository(String id) {
        if (this.repositories == null) {
            throw new IllegalStateException("Repositories not loaded yet");
        }
        Repository repository = null;
        for (Repository repo : this.repositories) {
            if (!repo.generateId().equals(id)) continue;
            repository = repo;
            break;
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository '" + id + "' not found");
        }
        return repository;
    }

    private GitHubClient getGitHubClient() {
        return this.gitHubClient;
    }

    private static interface InternalProgressFeedback {
        public void onProgress(int var1, Integer var2);
    }
}

