package com.atlassian.jira.plugins.importer.github.importer.markup;

import com.atlassian.jira.plugins.importer.github.config.ConfigBean;
import com.atlassian.jira.plugins.importer.github.importer.DataBean;
import com.google.common.collect.ImmutableList;
import org.eclipse.egit.github.core.Repository;

import java.util.List;

public class MarkupConverter {

	private final DataBean dataBean;
	private final ConfigBean configBean;

	public MarkupConverter(DataBean dataBean, ConfigBean configBean) {
		this.dataBean = dataBean;
		this.configBean = configBean;
	}

	public ConversionResult convert(final Repository repository, final String content) {
		String currentContent = content;
		final List<NoFormatFragmentConverter> noFormatConverters = getNoFormatConverters();

		for (NoFormatFragmentConverter noFormatFragmentConverter : noFormatConverters) {
			currentContent = noFormatFragmentConverter.removeNoFormatFragments(currentContent);
		}

		final ConversionResult afterAttachments = getAttachmentConverter().convert(repository, currentContent);
		currentContent = afterAttachments.getConvertedContent();

		for (SimpleConverter simpleConverter : getSimpleConverters()) {
			currentContent = simpleConverter.convertMarkdown(currentContent);
		}

		for (NoFormatFragmentConverter noFormatFragmentConverter : noFormatConverters) {
			currentContent = noFormatFragmentConverter.putBackNoFormatFragments(currentContent);
		}

		return new ConversionResult(afterAttachments.getAttachments(), currentContent);
	}

	private List<NoFormatFragmentConverter> getNoFormatConverters() {
		return ImmutableList.<NoFormatFragmentConverter>of(new CodeFragmentConverter());
	}

	private List<SimpleConverter> getSimpleConverters() {
		return ImmutableList.of(new SimpleSyntax(), new MentionConverter(dataBean));
	}

	private AttachmentsConverter getAttachmentConverter() {
		return new AttachmentsConverter(configBean);
	}

}
