package com.atlassian.jira.plugins.importer.github.fetch.auth;

import com.google.common.base.Objects;
import org.codehaus.jackson.map.ObjectMapper;

import javax.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.InputStream;

@XmlRootElement
public class AccessTokenResponse {
	public String access_token;
	public String token_type;
	public String scope;
	public String error;

	private AccessTokenResponse(){}

	@Override
	public String toString() {
		return Objects.toStringHelper(this)
				.add("access_token", access_token)
				.add("token_type", token_type)
				.add("scope", scope)
				.add("error", error).toString();
	}

	public static AccessTokenResponse readFromStream(InputStream inputStream) throws IOException {
		final ObjectMapper mapper = new ObjectMapper();
		return mapper.readValue(inputStream, AccessTokenResponse.class);
	}
}
