AJS.test.require(["com.atlassian.jira.plugins.jira-editor-plugin:round-trip",],function(){var c=require("jquery");var b=require("underscore");var a=require("jira/editor/analytics");module("RoundTrip",{setup:function(){this.clock=sinon.useFakeTimers();this.sandbox=sinon.sandbox.create();this.mockStorage={getItem:function(d){return this[d]},setItem:function(d,e){this[d]=e}};this.context=AJS.test.mockableModuleContext();this.context.mock("jira/data/local-storage",this.mockStorage);this.context.mock("jira/editor/analytics",a);this.sandbox.stub(a,"sendEvent");this.controller=this.context.mock("jira/editor/controller",{renderMarkup:function(d){return{"*wrong_":new c.Deferred().resolve("<p>*wrong_</p>"),"*strong*":new c.Deferred().resolve("<p><b>strong</b></p>")}[d]||new c.Deferred().reject()}})},teardown:function(){this.sandbox.restore();this.clock.restore()}});test("Should not send on first run",function(){var d=this.context.require("jira/editor/round-trip");d.verify("<p><b>strong</b></p>","*strong*",{});this.clock.tick(30*1000);var e=d.get();equal(e.average,1);equal(e.count,1);equal(a.sendEvent.callCount,0)});test("Should reset after wrap limit",function(){var d=this.context.require("jira/editor/round-trip");for(var e=0;e<50;e++){d.verify("<p><b>strong</b></p>","*strong*",{});this.clock.tick(30*1000)}var f=d.get();equal(f.average,1);equal(f.count,50);for(var e=0;e<50;e++){d.verify("<p><b>wrong</b></p>","*wrong_",{});this.clock.tick(30*1000)}var f=d.get();equal(Math.floor(f.average*100),49);equal(f.count,100);equal(a.sendEvent.callCount,50);equal(a.sendEvent.getCalls().every(function(g){return g.args[0]==="editor.instance.roundtrip.score.raw"}),true,"Only raw events");this.clock.tick(25*60*60*1000);d.verify("<p><b>wrong</b></p>","*wrong_",{});this.clock.tick(30*1000);f=d.get();equal(Math.floor(f.average*100),0);equal(f.count,1);equal(a.sendEvent.callCount,52);deepEqual(b.countBy(a.sendEvent.getCalls(),function(g){return g.args[0]}),{"editor.instance.roundtrip.score.raw":51,"editor.instance.roundtrip.score":1})});test("Should not send event when localStorage is full",function(){var d=this.context.require("jira/editor/round-trip");for(var e=0;e<50;e++){d.verify("<p><b>strong</b></p>","*strong*",{});this.clock.tick(30*1000)}var f=d.get();equal(f.average,1);equal(f.count,50);equal(a.sendEvent.callCount,0);this.mockStorage.setItem=this.sandbox.stub()["throws"]("QUOTA_EXCEEDED_ERR");this.clock.tick(25*60*60*1000);d.verify("*wrong_",{});this.clock.tick(30*1000);equal(a.sendEvent.callCount,0)});test("Should normalize html",function(){var d=this.context.require("jira/editor/round-trip");this.sandbox.stub(this.context.require("jira/editor/controller"),"renderMarkup").returns(new c.Deferred().resolve("<p><strong>strong</strong></p><p>text</p>","*strong*\n\ntext"));d.verify("<p><b>strong</b></p>\n\n<p>text</p>","*strong*\n\ntext",{});this.clock.tick(30*1000);var e=d.get();equal(e.average,1);equal(a.sendEvent.callCount,0)});test("Verify scoring",function(){var e=this.context.require("jira/editor/round-trip");var d=this.sandbox.stub(this.context.require("jira/editor/controller"),"renderMarkup");var f=function(i,g,j,h){this.mockStorage["jira.editor.score"]=null;d.returns(new c.Deferred().resolve(j));e.verify(i,g,{});this.clock.tick(30*1000);var k=e.get();equal(k.average,h,i+" -> "+g+" -> "+j+" ("+h+")")}.bind(this);f("just text","just text","just text",1);f("other text","other text","just text",0);f("<p>unwrapped para</p>","unwrapped para","unwrapped para",1);f("<b>bold</b>","*bold*","<b>bold</b>",1);f("<strong>strong</strong>","*strong*","<b>bold</b>",0.5);f("<strong>strong</strong>","*strong*","<em>strong</em>",0.5);f('this is <img src="data:base64" data-filename="image.png"/>',"this is !image.png!","this is <span class=\"error\">No usable issue stored in the context, unable to resolve filename 'image.png'</span>",1);f("just text <ul><li>nested <code>content</code></li></ul>","just text\n- {{content}}","just text <ul><li>nested <code>nonsense</code></li></ul>",1-1/6);f('<div class="table-wrap"><table><td>cell</td></table></div>',"|cell|","<table><td>cell</td></table>",1);f('order of attr matters: <img src="image.png" height="119" width="111" style="border: 0px solid black;" data-mce-src="/jira/secure/attachment/10000/10000_image-2016-09-12-17-40-52-522.png" data-mce-style="border: 0px solid black;">',"order of attr matters: !image.png|width=111,height=119!",'order of attr matters: <img src="image.png" width="111" style="border: 0px solid black" height="119">',1);f('<div class="code panel" style="border-width: 1px;"><div class="codeContent panelContent"><pre class="code-java">dupa</pre></div></div>',"{code:java}dupa{code}",'<div class="code panel" style="border-width: 1px;" data-mce-style="border-width: 1px;"><div class="codeContent panelContent"><pre class="code-java">dupa</pre></div></div>',1)})});