define("jira/editor/converter/handlers/quote-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler"
], function (
    NodeHandler,
    TextHandler
) {
    "use strict";

    /**
     * @class QuoteHandler
     * @extends NodeHandler
     */
    return NodeHandler.extend({
        init: function QuoteHandler(node) {
            this.node = node;
        },

        before: function () {
            return TextHandler.createPreformattedTextHandler('{quote}');
        },

        after: function () {
            return TextHandler.createPreformattedTextHandler('{quote}');
        }
    });
});