define("jira/editor/converter/handlers/panel-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/handlers/block-handler"
], function (
    NodeHandler,
    TextHandler,
    BlockHandler
) {
    "use strict";

    /**
     * @class PanelHandler
     * @extends NodeHandler
     */
    return BlockHandler.extend({
        init: function PanelHandler(node) {
            if (node.firstChild && node.className === node.firstChild.className) {
                node = node.firstChild;
            }
            this.node = node;

            this._super(node);
        },

        before: function () {
            var attrs = this.attrs ? ':' + this.attrs : '';
            return TextHandler.createPreformattedTextHandler('{panel' + attrs + '}');
        },

        createChildHandler: function () {
            return NodeHandler.prototype.createChildHandler.apply(this, arguments);
        },

        after: function () {
            return TextHandler.createPreformattedTextHandler('{panel}');
        }
    });
});