AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:converter'], function () {
    var _ = require('underscore');
    var $ = require('jquery');
    var NodeHandler;

    module('NodeHandler', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            NodeHandler = require('jira/editor/converter/handlers/node-handler');
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Test no wrapping selector: table.node', function () {
        var tableNode = $('<table><tbody><tr><td><b>bold</b></td></tr></table></tbody>').get(0);
        var node = $(tableNode).find('b').get(0);

        ok(NodeHandler.isInsideTable(node));
    });

    test('Test in wrapping selector: table.wrapper.node', function () {
        var tableNode = $('<table><tbody><tr><td><p><b>bold</b></p></td></tr></table></tbody>').get(0);
        var node = $(tableNode).find('b').get(0);

        ok(NodeHandler.isInsideTable(node));
    });

    test('Test no outer table', function () {
        var outerNode = $('<p><b>bold</b></p>').get(0);
        var node = $(outerNode).find('b').get(0);
        console.log(node);

        ok(!NodeHandler.isInsideTable(node), "Table found where it does not exist");
    });

    module('NodeHandler._isBlock', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            // stub `_.memoize` so that it always calls the original function
            this.memoizeStub = this.sandbox.stub(_, "memoize", function (func) {
                return function() {
                    return func.apply(this, arguments);
                };
            });
            NodeHandler = require('jira/editor/converter/handlers/node-handler');
        },

        teardown: function () {
            document.body.style.display = '';
            this.memoizeStub.restore();
            this.sandbox.restore();
        }
    });

    test('should return true for div element', function() {
        ok(NodeHandler._isBlock(document.createElement('div')));
    });

    test('should still return true for div element, when body has `display: flex;`', function() {
        document.body.style.display = 'flex';
        ok(NodeHandler._isBlock(document.createElement('div')));
    });

    test('should return false for tbody element', function() {
        ok(!NodeHandler._isBlock(document.createElement('tbody')));
    });

    test('should still return false for tbody element, when body has `display: flex;`', function() {
        document.body.style.display = 'flex';
        ok(!NodeHandler._isBlock(document.createElement('tbody')));
    });
});