AJS.test.require(['com.atlassian.jira.plugins.jira-editor-plugin:converter'], function () {
    "use strict";
    const RTEImageHandler = require('jira/editor/converter/handlers/image-handler');

    module('RTEImageHandler imageType tests', {
        setup: function () {
            this.dataset = [
                this.data(
                    this.imgElement(),
                    undefined,
                    'empty src attribute should result in undefined imageType'
                ),
                this.data(
                    this.imgElement({'imagetext': 'someimage'}),
                    'placeholder',
                    'if imagetext attribute is preset then "placeholder" imageType should be set'
                ),
                this.data(
                    this.imgElement({'src': '/images/icons/emoticons/smile.gif'}, "emoticon"),
                    'emote',
                    'for emoticons should use "emote" as imageType'
                ),
                this.data(
                    this.imgElement({'src': '/secure/attachment/file.gif'}),
                    'attachment-image',
                    'for attachments should use "attachment-image" as imageType'
                ),
                this.data(
                    this.imgElement({'src': '/secure/thumbnail/small_file.gif'}),
                    'attachment-image',
                    'for thumbnails should use "attachment-image" as imageType'
                ),
                this.data(
                    this.imgElement({'src': 'data:http,testdata'}),
                    'attachment-image',
                    'for data urls (data:http,testdata) should use "attachment-image" as imageType'
                ),
                this.data(
                    this.imgElement({'src': 'blob:http,testdata'}),
                    'attachment-image',
                    'for data urls (blob:http,testdata) should use "attachment-image" as imageType'
                ),
                this.data(
                    this.imgElement({'src': 'data:image,testdata'}),
                    'attachment-image',
                    'for data urls (data:image,testdata) should use "attachment-image" as imageType'
                ),
                this.data(
                    this.imgElement({'src': '/secure/temporaryattachment/file.gif'}),
                    'temporary-attachment-image',
                    'for temporary attachments should use "temporary-attachment-image" as imageType'
                ),
                this.data(
                    this.imgElement({'src': 'http://somedomain.invalid/file.gif'}),
                    'external-image',
                    'for external links should use "external-image" as imageType'
                ),
            ];
        },

        data: function (imgElement, expectedImageType, description) {
            return {
                imgElement: imgElement,
                expectedImageType: expectedImageType,
                description: description,
            };
        },

        imgElement: function (attributes, cssClass) {
            const img = document.createElement('img');
            if (attributes) {
                for (var property in attributes) {
                    if ({}.hasOwnProperty.call(attributes, property)) {
                        img.setAttribute(property, attributes[property]);
                    }
                }
            }
            if (cssClass) {
                img.classList.add(cssClass);
            }
            return img;
        }
    });

    test('Should set proper handler.imageType depending on <img> content', function (assert) {
        this.dataset.forEach(function (data) {
            const handler = new RTEImageHandler(data.imgElement);

            assert.equal(handler.imageType, data.expectedImageType, data.description);
        });
    });
});
