define("jira/editor/converter/handlers/external-handler", [
    "jira/editor/converter/handlers/node-handler",
    "jira/editor/converter/handlers/text-handler",
    "jira/editor/converter/new-lines/new-lines",
    "jira/editor/converter",
    "underscore"
], function (
    NodeHandler,
    TextHandler,
    NewLines,
    converter,
    _
) {
    "use strict";

    /**
     * @class ExternalHandler
     * @extends NodeHandler
     */
    var ExternalHandler = NodeHandler.extend({
        init: function(node) {
            this.node = node;
        },

        children: function() {
            var markup = this.external(this.getParams());
            return [TextHandler.createPreformattedTextHandler(markup)];
        },

        getParams: function() {
            return Object.create(Object.prototype, {
                node: { value: this.node },
                innerMarkup: {
                    get: function () {
                        return converter.handleMarkup(this.node.innerHTML);
                    }
                }
            });
        }
    });

    ExternalHandler.forConverter = function(definition) {
        var external = AJS.namespace(definition["function"]);

        if (!_.isFunction(external)) {
            console.error(definition["function"], " is not a function, this macro won't be supported by converter: ", definition.selector, " - it may result in data loss.");
            return;
        }

        NodeHandler.addHandler(definition.selector,
            ExternalHandler.extend({
                external: external
            })
        );
    };

    ExternalHandler.Legacy = TextHandler.extend({
        init: function (node) {
            this.node = node;
        },

        processText: function () {
            var originalText = this.node.getAttribute("data-original-text");
            var command = this.node.getAttribute("data-command");
            return (originalText || "") + (this.node.innerText || this.node.textContent) + (command && ("{" + command + "}"));
        },

        newLinesBefore: function () {
            return this.node.getAttribute("data-new-line-before") === "true" ? NewLines.single(true) : NewLines.empty();
        },

        newLinesAfter: function () {
            return this.node.getAttribute("data-new-line-after") === "true" ? NewLines.single(true) : NewLines.empty();
        }
    });

    return ExternalHandler;
});