/**
 * Utility functions for parsing and manipulating string values.
 * @module jira/editor/util/strings
 */
define('jira/editor/util/strings', [
    'exports'
], function(
    exports
) {
    'use strict';

    exports.getFilenameFromError = function (text) {
        return text &&
            (text.match(/^Unable to render embedded object: File \(([^)]+)\) not found\.$/) ||
             text.match(/^No usable issue stored in the context, unable to resolve filename '([^']+)'$/) ||
            [])[1];
    };
});
